/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item.base;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.item.BaseCookie;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class BaseSpecialCookie
extends BaseCookie {
    protected static final ParticleOptions[] SPECIAL_PARTICLES = new ParticleOptions[]{ParticleTypes.SOUL, ParticleTypes.SOUL_FIRE_FLAME, ParticleTypes.SMOKE, ParticleTypes.LARGE_SMOKE, ParticleTypes.WARPED_SPORE, ParticleTypes.CRIMSON_SPORE};

    protected BaseSpecialCookie(CookieType cookieType) {
        super(cookieType);
    }

    protected void spawnParticles(Level level, LivingEntity livingEntity) {
        int i;
        ParticleOptions particle = SPECIAL_PARTICLES[level.random.nextInt(SPECIAL_PARTICLES.length)];
        for (i = 0; i < 15; ++i) {
            double angle = Math.PI * 2 * (double)i / 15.0;
            double offsetX = Math.cos(angle) * 0.5;
            double offsetZ = Math.sin(angle) * 0.5;
            level.addParticle(particle, livingEntity.getX() + offsetX, livingEntity.getY() + 1.0, livingEntity.getZ() + offsetZ, 0.0, 0.1, 0.0);
        }
        for (i = 0; i < 10; ++i) {
            level.addParticle(particle, livingEntity.getX() + (level.random.nextDouble() - 0.5) * 1.5, livingEntity.getY() + level.random.nextDouble() * 2.0, livingEntity.getZ() + (level.random.nextDouble() - 0.5) * 1.5, (level.random.nextDouble() - 0.5) * 0.1, level.random.nextDouble() * 0.1, (level.random.nextDouble() - 0.5) * 0.1);
        }
    }

    @Override
    public boolean isFoil(ItemStack itemStack) {
        return true;
    }
}

