/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect;

import de.markusbordihn.cookiescandyandcakes.effect.ClientEffectInterface;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_746;

public class ClientEffectManager {
    private final Map<UUID, ActiveEffect> activeEffects = new ConcurrentHashMap<UUID, ActiveEffect>();

    public void applyEffect(class_746 player, ClientEffectInterface effect) {
        if (player == null || effect == null) {
            return;
        }
        UUID playerUUID = player.method_5667();
        ActiveEffect existingEffect = this.activeEffects.get(playerUUID);
        if (existingEffect != null) {
            existingEffect.effect.onEnd(player);
        }
        this.activeEffects.put(playerUUID, new ActiveEffect(effect, 0, effect.getDuration()));
        effect.onStart(player);
    }

    public void tick(class_746 player) {
        if (player == null) {
            return;
        }
        UUID playerUUID = player.method_5667();
        ActiveEffect activeEffect = this.activeEffects.get(playerUUID);
        if (activeEffect != null) {
            activeEffect.tick(player);
            if (activeEffect.isExpired()) {
                activeEffect.effect.onEnd(player);
                this.activeEffects.remove(playerUUID);
            }
        }
    }

    public void removeEffect(class_746 player) {
        UUID playerUUID;
        ActiveEffect activeEffect;
        if (player != null && (activeEffect = this.activeEffects.remove(playerUUID = player.method_5667())) != null) {
            activeEffect.effect.onEnd(player);
        }
    }

    public void clearAll() {
        this.activeEffects.clear();
    }

    public boolean hasActiveEffect(class_746 player) {
        return player != null && this.activeEffects.containsKey(player.method_5667());
    }

    static class ActiveEffect {
        private final ClientEffectInterface effect;
        private final int duration;
        private int elapsedTicks;

        public ActiveEffect(ClientEffectInterface effect, int elapsedTicks, int duration) {
            this.effect = effect;
            this.elapsedTicks = elapsedTicks;
            this.duration = duration;
        }

        public void tick(class_746 player) {
            this.effect.tick(player, this.elapsedTicks);
            ++this.elapsedTicks;
        }

        public boolean isExpired() {
            return this.elapsedTicks >= this.duration;
        }
    }
}

