/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.config;

import de.markusbordihn.cookiescandyandcakes.config.Config;
import de.markusbordihn.cookiescandyandcakes.data.SpecialItemEffect;
import de.markusbordihn.cookiescandyandcakes.data.candies.CandyType;
import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;

public class CandyConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "candies.cfg";
    public static final String CONFIG_FILE_HEADER = " Candy Configuration\n\n This configuration file allows you to customize candy properties per type.\n\n General Settings:\n - nutrition: Food points restored (default: 2)\n - effectDuration: Duration of potion effects in ticks (default: 200 = 10 seconds, 20 ticks = 1 second)\n - effectChance: Chance for potion effects to apply (0.0-1.0, default: 1.0 = 100%)\n\n Special Candy Effects (for MYSTIC and CURSED variants):\n - specialEffect.lightningChance: Chance for lightning effect (0.0-1.0, default: 0.5 = 50%)\n - specialEffect.enableSounds: Enable dramatic sound effects (default: true)\n - specialEffect.soundVolume: Volume of sound effects (MYSTIC default: 1.0, CURSED default: 4.0)\n - specialEffect.enableDarknessEffect: Enable darkness effect for CURSED candies (default: true, disable for epilepsy/photosensitivity)\n - specialEffect.darknessEffectDuration: Duration of darkness effect in ticks for CURSED candies (default: 60 = 3 seconds)\n - specialEffect.mysticSoundType: Sound type for MYSTIC candies (levelup, enchant, amethyst, bell, none; default: levelup)\n - specialEffect.cursedSoundType: Sound type for CURSED candies (ender_dragon, wither, ambient_cave, sculk, none; default: ender_dragon)\n\n Available Sound Types:\n - MYSTIC: levelup, enchant, amethyst, bell, none\n - CURSED: ender_dragon, wither, ambient_cave, sculk, none\n\n Accessibility Note:\n - Set specialEffect.enableDarknessEffect to false if you have epilepsy or are sensitive to screen flashing/darkening effects\n\n You can configure these values globally or per candy type by prefixing with the candy type ID.\n Example: apple_candy_mystic.nutrition = 3\n\n";
    private static final Map<CandyType, Integer> nutritionOverrides = new EnumMap<CandyType, Integer>(CandyType.class);
    private static final Map<CandyType, Integer> effectDurationOverrides = new EnumMap<CandyType, Integer>(CandyType.class);
    private static final Map<CandyType, Float> effectChanceOverrides = new EnumMap<CandyType, Float>(CandyType.class);
    private static int defaultNutrition = 2;
    private static int defaultEffectDuration = 200;
    private static float defaultEffectChance = 1.0f;
    private static float specialEffectLightningChance = 0.5f;
    private static boolean specialEffectEnableSounds = true;
    private static boolean specialEffectEnableDarknessEffect = true;
    private static float specialEffectMysticSoundVolume = 1.0f;
    private static float specialEffectCursedSoundVolume = 4.0f;
    private static int specialEffectDarknessEffectDuration = 60;
    private static String specialEffectMysticSoundType = "levelup";
    private static String specialEffectCursedSoundType = "ender_dragon";

    public static void registerConfig() {
        CandyConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        CandyConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = CandyConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = CandyConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        defaultNutrition = CandyConfig.parseConfigValue(properties, "nutrition", defaultNutrition);
        defaultEffectDuration = CandyConfig.parseConfigValue(properties, "effectDuration", defaultEffectDuration);
        defaultEffectChance = CandyConfig.parseConfigValue(properties, "effectChance", defaultEffectChance);
        specialEffectLightningChance = CandyConfig.parseConfigValue(properties, "specialEffect.lightningChance", specialEffectLightningChance);
        specialEffectEnableSounds = CandyConfig.parseConfigValue(properties, "specialEffect.enableSounds", specialEffectEnableSounds);
        specialEffectEnableDarknessEffect = CandyConfig.parseConfigValue(properties, "specialEffect.enableDarknessEffect", specialEffectEnableDarknessEffect);
        specialEffectMysticSoundVolume = CandyConfig.parseConfigValue(properties, "specialEffect.mysticSoundVolume", specialEffectMysticSoundVolume);
        specialEffectCursedSoundVolume = CandyConfig.parseConfigValue(properties, "specialEffect.cursedSoundVolume", specialEffectCursedSoundVolume);
        specialEffectDarknessEffectDuration = CandyConfig.parseConfigValue(properties, "specialEffect.darknessEffectDuration", specialEffectDarknessEffectDuration);
        specialEffectMysticSoundType = CandyConfig.parseConfigValue(properties, "specialEffect.mysticSoundType", specialEffectMysticSoundType);
        specialEffectCursedSoundType = CandyConfig.parseConfigValue(properties, "specialEffect.cursedSoundType", specialEffectCursedSoundType);
        nutritionOverrides.clear();
        effectDurationOverrides.clear();
        effectChanceOverrides.clear();
        for (CandyType type : CandyType.values()) {
            String camelCaseName = CandyConfig.toCamelCase(type.getId());
            String prefix = "candy." + camelCaseName + ".";
            nutritionOverrides.put(type, CandyConfig.parseConfigValue(properties, prefix + "nutrition", defaultNutrition));
            effectDurationOverrides.put(type, CandyConfig.parseConfigValue(properties, prefix + "effectDuration", defaultEffectDuration));
            effectChanceOverrides.put(type, Float.valueOf(CandyConfig.parseConfigValue(properties, prefix + "effectChance", defaultEffectChance)));
        }
        CandyConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static int getNutrition(CandyType type) {
        return nutritionOverrides.getOrDefault((Object)type, defaultNutrition);
    }

    public static int getEffectDuration(CandyType type) {
        return effectDurationOverrides.getOrDefault((Object)type, defaultEffectDuration);
    }

    public static float getEffectChance(CandyType type) {
        return effectChanceOverrides.getOrDefault((Object)type, Float.valueOf(defaultEffectChance)).floatValue();
    }

    public static SpecialItemEffect getSpecialCandyEffect(CandyType type) {
        if (type.getVariant() == CandyType.CandyVariant.MYSTIC) {
            return new SpecialItemEffect(specialEffectLightningChance, specialEffectEnableSounds, specialEffectMysticSoundVolume, 0, specialEffectMysticSoundType, "none");
        }
        if (type.getVariant() == CandyType.CandyVariant.CURSED) {
            return new SpecialItemEffect(specialEffectLightningChance, specialEffectEnableSounds, specialEffectCursedSoundVolume, specialEffectEnableDarknessEffect ? specialEffectDarknessEffectDuration : 0, "none", specialEffectCursedSoundType);
        }
        return SpecialItemEffect.NONE;
    }
}

