/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.config;

import de.markusbordihn.cookiescandyandcakes.config.Config;
import de.markusbordihn.cookiescandyandcakes.data.candies.CandyType;
import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;

public class MonsterLootConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "monster_loot.cfg";
    public static final String CONFIG_FILE_HEADER = " Monster Loot Configuration\n\n This configuration file allows you to define drop chances for special cookies and candies from monsters.\n Drop chances are in percentage (0-100). Set to 0 to disable drops for that item.\n The global drop chance determines if ANY special item will drop (25% default).\n\n Cookie Drops: Special MYSTIC and CURSED cookie variants\n Candy Drops: Special MYSTIC and CURSED candy variants\n\n Drop weights determine the relative probability of each item dropping.\n Higher weight = more likely to drop. Set to 0 to disable that specific item.\n\n";
    private static final Map<CookieType, Integer> cookieDropWeights = new EnumMap<CookieType, Integer>(CookieType.class);
    private static final Map<CandyType, Integer> candyDropWeights = new EnumMap<CandyType, Integer>(CandyType.class);
    public static int globalDropChance = 25;

    public static void registerConfig() {
        MonsterLootConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        MonsterLootConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        int weight;
        int defaultWeight;
        String key;
        String camelCaseName;
        File configFile = MonsterLootConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = MonsterLootConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        globalDropChance = MonsterLootConfig.parseConfigValue(properties, "globalDropChance", globalDropChance);
        cookieDropWeights.clear();
        candyDropWeights.clear();
        for (CookieType cookieType : CookieType.values()) {
            if (cookieType.getVariant() != CookieType.CookieVariant.MYSTIC && cookieType.getVariant() != CookieType.CookieVariant.CURSED) continue;
            camelCaseName = MonsterLootConfig.toCamelCase(cookieType.getId());
            key = "cookie." + camelCaseName + ".dropWeight";
            defaultWeight = 1;
            weight = MonsterLootConfig.parseConfigValue(properties, key, defaultWeight);
            cookieDropWeights.put(cookieType, weight);
        }
        for (Enum enum_ : CandyType.values()) {
            if (((CandyType)enum_).getVariant() != CandyType.CandyVariant.MYSTIC && ((CandyType)enum_).getVariant() != CandyType.CandyVariant.CURSED) continue;
            camelCaseName = MonsterLootConfig.toCamelCase(((CandyType)enum_).getId());
            key = "candy." + camelCaseName + ".dropWeight";
            defaultWeight = 1;
            weight = MonsterLootConfig.parseConfigValue(properties, key, defaultWeight);
            candyDropWeights.put((CandyType)enum_, weight);
        }
        MonsterLootConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static int getCookieDropWeight(CookieType type) {
        return cookieDropWeights.getOrDefault((Object)type, 0);
    }

    public static int getCandyDropWeight(CandyType type) {
        return candyDropWeights.getOrDefault((Object)type, 0);
    }
}

