/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.event;

import de.markusbordihn.cookiescandyandcakes.config.MonsterLootConfig;
import de.markusbordihn.cookiescandyandcakes.data.candies.CandyType;
import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.registry.ModItems;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;

public class MonsterLootHandler {
    private static final int REFRESH_INTERVAL = 100;
    private static List<class_1792> cachedWeightedItems = null;
    private static int callsSinceLastRefresh = 0;

    private MonsterLootHandler() {
    }

    public static boolean shouldDropSpecialCookies(class_1297 entity) {
        if (!(entity instanceof class_1588)) {
            return false;
        }
        float dropChance = (float)MonsterLootConfig.globalDropChance / 100.0f;
        return entity.method_37908().method_8409().method_43057() < dropChance;
    }

    private static List<class_1792> buildWeightedItemList() {
        int i;
        class_1792 item;
        int weight;
        ArrayList<class_1792> weightedItems = new ArrayList<class_1792>();
        for (CookieType cookieType : CookieType.values()) {
            if (cookieType.getVariant() != CookieType.CookieVariant.MYSTIC && cookieType.getVariant() != CookieType.CookieVariant.CURSED) continue;
            weight = MonsterLootConfig.getCookieDropWeight(cookieType);
            item = MonsterLootHandler.getCookieItem(cookieType);
            if (item == null) continue;
            for (i = 0; i < weight; ++i) {
                weightedItems.add(item);
            }
        }
        for (Enum enum_ : CandyType.values()) {
            if (((CandyType)enum_).getVariant() != CandyType.CandyVariant.MYSTIC && ((CandyType)enum_).getVariant() != CandyType.CandyVariant.CURSED) continue;
            weight = MonsterLootConfig.getCandyDropWeight((CandyType)enum_);
            item = MonsterLootHandler.getCandyItem((CandyType)enum_);
            if (item == null) continue;
            for (i = 0; i < weight; ++i) {
                weightedItems.add(item);
            }
        }
        return weightedItems;
    }

    private static class_1792 getCookieItem(CookieType cookieType) {
        try {
            String fieldName = cookieType.name();
            Field field = ModItems.class.getDeclaredField(fieldName);
            return (class_1792)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class_1792 getCandyItem(CandyType candyType) {
        try {
            String fieldName = candyType.name();
            Field field = ModItems.class.getDeclaredField(fieldName);
            return (class_1792)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class_1799 getRandomSpecialCookie(class_1297 entity) {
        if (cachedWeightedItems == null || ++callsSinceLastRefresh >= 100) {
            cachedWeightedItems = MonsterLootHandler.buildWeightedItemList();
            callsSinceLastRefresh = 0;
        }
        if (cachedWeightedItems.isEmpty()) {
            return class_1799.field_8037;
        }
        class_1792 item = cachedWeightedItems.get(entity.method_37908().method_8409().method_43048(cachedWeightedItems.size()));
        return new class_1799((class_1935)item);
    }

    public static class_1542 createSpecialCookieDrop(class_1297 entity) {
        return new class_1542(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321(), MonsterLootHandler.getRandomSpecialCookie(entity));
    }
}

