/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item;

import de.markusbordihn.cookiescandyandcakes.data.candies.CandyType;
import de.markusbordihn.cookiescandyandcakes.entity.ThrownCandy;
import de.markusbordihn.cookiescandyandcakes.registry.ModEntityTypes;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4174;

public abstract class BaseCandy
extends class_1792 {
    private static final int STACK_SIZE = 16;
    private static final int THROW_MIN_TICKS = 2;
    private static final int SHOW_BAR_MIN_TICKS = 5;
    private static final int THROW_MAX_TICKS = 20;
    private static final int PAUSE_TICKS = 22;
    private static final int EAT_START_TICKS = 27;
    private static final int USE_DURATION_TICKS = 55;
    private static final float THROW_MIN_VELOCITY = 0.5f;
    private static final float THROW_MAX_VELOCITY = 1.5f;
    private static final float THROW_INACCURACY = 1.0f;
    private static final float LOOK_DOWN_ANGLE = 45.0f;
    protected final CandyType candyType;

    protected BaseCandy(CandyType candyType) {
        super(new class_1792.class_1793().method_19265(BaseCandy.buildFoodProperties(candyType)).method_7889(16));
        this.candyType = candyType;
    }

    protected static class_4174 buildFoodProperties(CandyType candyType) {
        class_4174.class_4175 builder = new class_4174.class_4175().method_19238(candyType.getNutrition()).method_19241();
        if (candyType.hasEffect()) {
            builder.method_19239(new class_1293(candyType.getEffect(), candyType.getEffectDuration(), candyType.getAmplifier()), candyType.getEffectChance());
        }
        return builder.method_19242();
    }

    public static int getThrowMinTicks() {
        return 2;
    }

    public static int getShowBarMinTicks() {
        return 5;
    }

    public static int getThrowMaxTicks() {
        return 20;
    }

    public static int getPauseTicks() {
        return 22;
    }

    public static int getEatStartTicks() {
        return 27;
    }

    public CandyType getCandyType() {
        return this.candyType;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        player.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    private boolean shouldEatDirectly(class_1657 player) {
        if (player.method_36455() < 45.0f) {
            return false;
        }
        class_243 eyePos = player.method_33571();
        class_3965 hitResult = player.method_37908().method_17742(new class_3959(eyePos, eyePos.method_1019(player.method_5720().method_1021(2.5)), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        return hitResult.method_17783() == class_239.class_240.field_1332 && !player.method_37908().method_8320(hitResult.method_17777()).method_26215();
    }

    public void method_7840(class_1799 itemStack, class_1937 level, class_1309 entity, int timeLeft) {
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        int useDuration = this.method_7881(itemStack, entity);
        int usedTicks = useDuration - timeLeft;
        if (usedTicks < 2 || usedTicks >= 27) {
            return;
        }
        if (!this.shouldEatDirectly(player)) {
            float velocity = this.calculateThrowVelocity(usedTicks);
            this.throwCandy(level, player, itemStack, velocity);
        }
    }

    private float calculateThrowVelocity(int usedTicks) {
        if (usedTicks < 2) {
            return 0.5f;
        }
        if (usedTicks >= 20) {
            return 1.5f;
        }
        int chargeTicks = usedTicks - 2;
        int maxChargeTicks = 18;
        float chargeProgress = (float)chargeTicks / (float)maxChargeTicks;
        return 0.5f + 1.0f * chargeProgress;
    }

    private void throwCandy(class_1937 level, class_1657 player, class_1799 itemStack, float velocity) {
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14873, class_3419.field_15248, 0.5f, 0.4f / (level.method_8409().method_43057() * 0.4f + 0.8f));
        if (!level.field_9236) {
            ThrownCandy thrownCandy = new ThrownCandy(ModEntityTypes.THROWN_CANDY.get(), level, (class_1309)player);
            thrownCandy.method_16940(itemStack.method_46651(1));
            thrownCandy.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, velocity, 1.0f);
            level.method_8649((class_1297)thrownCandy);
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
    }

    public class_1799 method_7861(class_1799 itemStack, class_1937 level, class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
        }
        return super.method_7861(itemStack, level, entity);
    }

    public int method_7881(class_1799 itemStack, class_1309 entity) {
        return 55;
    }

    public class_1839 method_7853(class_1799 itemStack) {
        return class_1839.field_8950;
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 flag) {
        tooltipComponents.add((class_2561)class_2561.method_43471((String)(this.method_7876() + ".desc")).method_27692(class_124.field_1063));
    }

    public boolean method_7886(class_1799 itemStack) {
        return this.candyType.getVariant() == CandyType.CandyVariant.MYSTIC;
    }
}

