/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect;

import de.markusbordihn.cookiescandyandcakes.effect.ServerEffectInterface;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3222;

public class ServerEffectManager {
    private final Map<UUID, ActiveEffect> activeEffects = new HashMap<UUID, ActiveEffect>();

    public void applyEffect(class_3222 player, ServerEffectInterface effect) {
        if (player == null || effect == null) {
            return;
        }
        UUID playerUUID = player.method_5667();
        this.activeEffects.put(playerUUID, new ActiveEffect(effect, 0, effect.getDuration()));
        effect.onStart(player);
    }

    public void tick(class_3222 player) {
        if (player == null) {
            return;
        }
        UUID playerUUID = player.method_5667();
        ActiveEffect activeEffect = this.activeEffects.get(playerUUID);
        if (activeEffect != null) {
            activeEffect.tick(player);
            if (activeEffect.isExpired()) {
                activeEffect.effect.onEnd(player);
                this.activeEffects.remove(playerUUID);
            }
        }
    }

    public void tickAll(Iterable<class_3222> players) {
        for (class_3222 player : players) {
            this.tick(player);
        }
    }

    public void removeEffect(class_3222 player) {
        UUID playerUUID;
        ActiveEffect activeEffect;
        if (player != null && (activeEffect = this.activeEffects.remove(playerUUID = player.method_5667())) != null) {
            activeEffect.effect.onEnd(player);
        }
    }

    public void clearAll() {
        this.activeEffects.clear();
    }

    public boolean hasActiveEffect(class_3222 player) {
        return player != null && this.activeEffects.containsKey(player.method_5667());
    }

    static class ActiveEffect {
        private final ServerEffectInterface effect;
        private final int duration;
        private int elapsedTicks;

        public ActiveEffect(ServerEffectInterface effect, int elapsedTicks, int duration) {
            this.effect = effect;
            this.elapsedTicks = elapsedTicks;
            this.duration = duration;
        }

        public void tick(class_3222 player) {
            this.effect.tick(player, this.elapsedTicks);
            ++this.elapsedTicks;
        }

        public boolean isExpired() {
            return this.elapsedTicks >= this.duration;
        }
    }
}

