/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect.cookie;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.effect.ServerEffectInterface;
import de.markusbordihn.cookiescandyandcakes.effect.ServerEffectManager;
import de.markusbordihn.cookiescandyandcakes.effect.cookie.server.SlimeSugarCookieMysticEffect;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3222;

public class CookieServerEffectManager
extends ServerEffectManager {
    private static final Map<CookieType, ServerEffectInterface> COOKIE_EFFECTS = new HashMap<CookieType, ServerEffectInterface>();
    private static final CookieServerEffectManager INSTANCE = new CookieServerEffectManager();

    private CookieServerEffectManager() {
    }

    public static CookieServerEffectManager getInstance() {
        return INSTANCE;
    }

    public static void applyCookieEffect(class_3222 player, CookieType cookieType) {
        if (player == null || cookieType == null) {
            return;
        }
        ServerEffectInterface effect = COOKIE_EFFECTS.get((Object)cookieType);
        if (effect != null) {
            CookieServerEffectManager.getInstance().applyEffect(player, effect);
        }
    }

    public static void tickPlayer(class_3222 player) {
        CookieServerEffectManager.getInstance().tick(player);
    }

    public static void tickPlayers(Iterable<class_3222> players) {
        CookieServerEffectManager.getInstance().tickAll(players);
    }

    public static void removeCookieEffect(class_3222 player) {
        CookieServerEffectManager.getInstance().removeEffect(player);
    }

    public static void clearAllEffects() {
        CookieServerEffectManager.getInstance().clearAll();
    }

    public static boolean hasCookieEffect(class_3222 player) {
        return CookieServerEffectManager.getInstance().hasActiveEffect(player);
    }

    static {
        COOKIE_EFFECTS.put(CookieType.SLIME_SUGAR_COOKIE_MYSTIC, new SlimeSugarCookieMysticEffect());
    }
}

