/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect;

import de.markusbordihn.cookiescandyandcakes.effect.ServerEffectInterface;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;

public class ServerEffectManager {
    private final Map<UUID, ActiveEffect> activeEffects = new HashMap<UUID, ActiveEffect>();

    public void applyEffect(ServerPlayer player, ServerEffectInterface effect) {
        if (player == null || effect == null) {
            return;
        }
        UUID playerUUID = player.getUUID();
        this.activeEffects.put(playerUUID, new ActiveEffect(effect, 0, effect.getDuration()));
        effect.onStart(player);
    }

    public void tick(ServerPlayer player) {
        if (player == null) {
            return;
        }
        UUID playerUUID = player.getUUID();
        ActiveEffect activeEffect = this.activeEffects.get(playerUUID);
        if (activeEffect != null) {
            activeEffect.tick(player);
            if (activeEffect.isExpired()) {
                activeEffect.effect.onEnd(player);
                this.activeEffects.remove(playerUUID);
            }
        }
    }

    public void tickAll(Iterable<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            this.tick(player);
        }
    }

    public void removeEffect(ServerPlayer player) {
        UUID playerUUID;
        ActiveEffect activeEffect;
        if (player != null && (activeEffect = this.activeEffects.remove(playerUUID = player.getUUID())) != null) {
            activeEffect.effect.onEnd(player);
        }
    }

    public void clearAll() {
        this.activeEffects.clear();
    }

    public boolean hasActiveEffect(ServerPlayer player) {
        return player != null && this.activeEffects.containsKey(player.getUUID());
    }

    static class ActiveEffect {
        private final ServerEffectInterface effect;
        private final int duration;
        private int elapsedTicks;

        public ActiveEffect(ServerEffectInterface effect, int elapsedTicks, int duration) {
            this.effect = effect;
            this.elapsedTicks = elapsedTicks;
            this.duration = duration;
        }

        public void tick(ServerPlayer player) {
            this.effect.tick(player, this.elapsedTicks);
            ++this.elapsedTicks;
        }

        public boolean isExpired() {
            return this.elapsedTicks >= this.duration;
        }
    }
}

