/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.menu;

import de.markusbordihn.cookiescandyandcakes.registry.ModMenuTypes;
import de.markusbordihn.cookiescandyandcakes.registry.ModTags;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CookieJarMenu
extends AbstractContainerMenu {
    private final Container container;
    private Runnable onCloseCallback;

    public CookieJarMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(27));
    }

    public CookieJarMenu(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(containerId, playerInventory, (Container)new SimpleContainer(27));
    }

    public CookieJarMenu(int containerId, Inventory playerInventory, Container container) {
        super(ModMenuTypes.getCookieJar(), containerId);
        int col;
        this.container = container;
        container.startOpen(playerInventory.player);
        int startX = 8;
        int startY = 18;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.addSlot(new CookieJarSlot(container, col2 + row * 9, startX + col2 * 18, startY + row * 18));
            }
        }
        int playerInventoryStartY = 135;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, startX + col * 18, playerInventoryStartY + row * 18));
            }
        }
        int hotbarY = 193;
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, startX + col * 18, hotbarY));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            result = stack.copy();
            if (index < 27) {
                if (!this.moveItemStackTo(stack, 27, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (stack.is(ModTags.COOKIE_JAR_ITEMS)) {
                if (!this.moveItemStackTo(stack, 0, 27, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return result;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public void removed(Player player) {
        super.removed(player);
        this.container.stopOpen(player);
        if (this.onCloseCallback != null) {
            this.onCloseCallback.run();
        }
    }

    public void setOnCloseCallback(Runnable callback) {
        this.onCloseCallback = callback;
    }

    public Container getContainer() {
        return this.container;
    }

    private static class CookieJarSlot
    extends Slot {
        public CookieJarSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.is(ModTags.COOKIE_JAR_ITEMS);
        }
    }
}

