/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.data.cookies;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class CookieSoundType {
    private CookieSoundType() {
    }

    public static SoundEvent getMysticSound(String soundType) {
        return switch (soundType.toLowerCase()) {
            case "levelup" -> SoundEvents.PLAYER_LEVELUP;
            case "enchant" -> SoundEvents.ENCHANTMENT_TABLE_USE;
            case "amethyst" -> SoundEvents.AMETHYST_BLOCK_CHIME;
            case "bell" -> SoundEvents.BELL_RESONATE;
            case "none" -> null;
            default -> SoundEvents.PLAYER_LEVELUP;
        };
    }

    public static SoundEvent getCursedSound(String soundType) {
        return switch (soundType.toLowerCase()) {
            case "ender_dragon" -> SoundEvents.ENDER_DRAGON_AMBIENT;
            case "wither" -> SoundEvents.WITHER_AMBIENT;
            case "ambient_cave" -> (SoundEvent)SoundEvents.AMBIENT_CAVE.value();
            case "sculk" -> SoundEvents.SCULK_SHRIEKER_SHRIEK;
            case "none" -> null;
            default -> SoundEvents.ENDER_DRAGON_AMBIENT;
        };
    }

    public static float getPitch(String soundType, float randomValue) {
        return switch (soundType.toLowerCase()) {
            case "levelup" -> 1.0f + randomValue * 0.2f;
            case "enchant" -> 0.8f + randomValue * 0.4f;
            case "amethyst" -> 1.2f + randomValue * 0.3f;
            case "bell" -> 0.9f + randomValue * 0.2f;
            case "ender_dragon" -> 0.7f + randomValue * 0.3f;
            case "wither" -> 0.6f + randomValue * 0.4f;
            case "ambient_cave" -> 1.0f;
            case "sculk" -> 0.8f + randomValue * 0.2f;
            default -> 1.0f;
        };
    }
}

