/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect.cookie.client;

import de.markusbordihn.cookiescandyandcakes.effect.ClientEffectInterface;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CreeperCrunchCookieCursedEffectClient
implements ClientEffectInterface {
    private static final int CREEPER_SPAWN_DISTANCE = 8;
    private static final int CREEPER_SPAWN_TICK = 20;
    private static final int CREEPER_MOVE_DURATION = 120;
    private static final int CREEPER_EXPLODE_TICK = 140;
    private static final int SOUND_INTERVAL = 20;
    private final List<FakeCreeper> fakeCreepers = new ArrayList<FakeCreeper>();

    @Override
    public int getDuration() {
        return 150;
    }

    @Override
    public void tick(LocalPlayer localPlayer, int elapsedTicks) {
        Level level = localPlayer.level();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        if (elapsedTicks == 20) {
            this.spawnFakeCreepers(clientLevel, localPlayer);
        } else if (elapsedTicks > 20 && elapsedTicks <= 140) {
            int progress = elapsedTicks - 20;
            if (progress % 20 == 0) {
                this.playCreeperSound(clientLevel, localPlayer.position());
            }
            this.updateFakeCreepers(clientLevel, localPlayer);
        } else {
            this.explodeFakeCreepers(clientLevel);
        }
    }

    @Override
    public void onStart(LocalPlayer localPlayer) {
        this.fakeCreepers.clear();
    }

    @Override
    public void onEnd(LocalPlayer localPlayer) {
        Level level = localPlayer.level();
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            this.removeFakeCreepers(clientLevel);
        }
        this.fakeCreepers.clear();
    }

    private void spawnFakeCreepers(ClientLevel level, LocalPlayer player) {
        Vec3 playerPos = player.position();
        for (int i = 0; i < 4; ++i) {
            Creeper creeper = (Creeper)EntityType.CREEPER.create((Level)level);
            if (creeper == null) continue;
            double angle = 1.5707963267948966 * (double)i;
            double offsetX = Math.cos(angle) * 8.0;
            double offsetZ = Math.sin(angle) * 8.0;
            creeper.igniteForTicks(120);
            creeper.setPos(playerPos.x + offsetX, playerPos.y, playerPos.z + offsetZ);
            creeper.setYRot((float)Math.toDegrees(angle + Math.PI));
            creeper.yRotO = creeper.getYRot();
            creeper.setYHeadRot(creeper.getYRot());
            creeper.setNoGravity(true);
            creeper.setInvulnerable(true);
            creeper.setSilent(false);
            level.addEntity((Entity)creeper);
            this.fakeCreepers.add(new FakeCreeper(creeper, playerPos.x, playerPos.y, playerPos.z));
        }
        this.playCreeperSound(level, playerPos);
    }

    private void playCreeperSound(ClientLevel level, Vec3 pos) {
        level.playLocalSound(pos.x, pos.y, pos.z, SoundEvents.CREEPER_PRIMED, SoundSource.HOSTILE, 2.0f, 1.0f, false);
    }

    private void updateFakeCreepers(ClientLevel level, LocalPlayer player) {
        Vec3 playerPos = player.position();
        for (FakeCreeper fakeCreeper : this.fakeCreepers) {
            Creeper creeper = fakeCreeper.creeper();
            if (!creeper.isAlive()) continue;
            Vec3 creeperPos = creeper.position();
            Vec3 direction = playerPos.subtract(creeperPos).normalize().scale(0.065);
            Vec3 newPos = creeperPos.add(direction);
            creeper.setPos(newPos.x, newPos.y, newPos.z);
            creeper.tick();
            float yaw = (float)(Math.atan2(playerPos.z - newPos.z, playerPos.x - newPos.x) * 180.0 / Math.PI) - 90.0f;
            creeper.setYRot(yaw);
            creeper.setYHeadRot(yaw);
        }
    }

    private void explodeFakeCreepers(ClientLevel level) {
        for (FakeCreeper fakeCreeper : this.fakeCreepers) {
            Creeper creeper = fakeCreeper.creeper();
            if (!creeper.isAlive()) continue;
            Vec3 pos = creeper.position();
            for (int i = 0; i < 30; ++i) {
                double offsetX = (level.random.nextDouble() - 0.5) * 3.0;
                double offsetY = level.random.nextDouble() * 3.0;
                double offsetZ = (level.random.nextDouble() - 0.5) * 3.0;
                level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, pos.x + offsetX, pos.y + offsetY, pos.z + offsetZ, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, pos.x + offsetX, pos.y + offsetY, pos.z + offsetZ, offsetX * 0.1, offsetY * 0.1, offsetZ * 0.1);
            }
            level.playLocalSound(pos.x, pos.y, pos.z, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.HOSTILE, 2.0f, 1.0f, false);
            creeper.discard();
        }
    }

    private void removeFakeCreepers(ClientLevel level) {
        for (FakeCreeper fakeCreeper : this.fakeCreepers) {
            Creeper creeper = fakeCreeper.creeper();
            if (!creeper.isAlive()) continue;
            creeper.discard();
        }
    }

    private record FakeCreeper(Creeper creeper, double startX, double startY, double startZ) {
    }
}

