/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect.cookie.client;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.effect.ClientEffectInterface;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;

public class CreeperCrunchCookieMysticEffectClient
implements ClientEffectInterface {
    private static final int PARTICLE_INTERVAL = 5;

    @Override
    public int getDuration() {
        return CookieType.CREEPER_CRUNCH_COOKIE_MYSTIC.getEffectDuration();
    }

    @Override
    public void tick(LocalPlayer localPlayer, int elapsedTicks) {
        Level level = localPlayer.level();
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            if (elapsedTicks % 5 == 0) {
                this.spawnCreeperParticles(clientLevel, localPlayer);
            }
        }
    }

    @Override
    public void onStart(LocalPlayer localPlayer) {
        Level level = localPlayer.level();
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            clientLevel.playLocalSound(localPlayer.getX(), localPlayer.getY(), localPlayer.getZ(), SoundEvents.CREEPER_PRIMED, SoundSource.PLAYERS, 1.0f, 1.5f, false);
        }
    }

    @Override
    public void onEnd(LocalPlayer localPlayer) {
    }

    private void spawnCreeperParticles(ClientLevel level, LocalPlayer player) {
        for (int i = 0; i < 3; ++i) {
            double offsetX = (level.random.nextDouble() - 0.5) * 0.8;
            double offsetY = level.random.nextDouble() * 1.2;
            double offsetZ = (level.random.nextDouble() - 0.5) * 0.8;
            level.addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, player.getX() + offsetX, player.getY() + offsetY, player.getZ() + offsetZ, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, player.getX() + offsetX, player.getY() + offsetY, player.getZ() + offsetZ, 0.0, 0.02, 0.0);
        }
    }
}

