/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect.cookie.server;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.effect.ServerEffectInterface;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ElderGuardianCookieMysticEffect
implements ServerEffectInterface {
    private static final int DROP_TICK = 220;

    @Override
    public int getDuration() {
        return CookieType.ELDER_GUARDIAN_COOKIE_MYSTIC.getEffectDuration();
    }

    @Override
    public void tick(ServerPlayer serverPlayer, int elapsedTicks) {
        Level level;
        if (elapsedTicks == 220 && (level = serverPlayer.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.dropAquamarineShard(serverLevel, serverPlayer);
        }
    }

    @Override
    public void onStart(ServerPlayer serverPlayer) {
    }

    @Override
    public void onEnd(ServerPlayer serverPlayer) {
    }

    private void dropAquamarineShard(ServerLevel serverLevel, ServerPlayer serverPlayer) {
        Vec3 playerPos = serverPlayer.position();
        ItemStack aquamarineShard = new ItemStack((ItemLike)Items.PRISMARINE_SHARD, 1);
        ItemEntity itemEntity = new ItemEntity((Level)serverLevel, playerPos.x, playerPos.y + 0.5, playerPos.z, aquamarineShard);
        itemEntity.setNoPickUpDelay();
        serverLevel.addFreshEntity((Entity)itemEntity);
    }
}

