/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect.cookie.server;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.effect.ServerEffectInterface;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SlimeSugarCookieMysticEffect
implements ServerEffectInterface {
    private static final int SLIMEBALL_DROP_INTERVAL = 40;
    private static final int SOUND_INTERVAL = 20;
    private int lastSoundTick = 0;

    @Override
    public int getDuration() {
        return CookieType.SLIME_SUGAR_COOKIE_MYSTIC.getEffectDuration();
    }

    @Override
    public void tick(ServerPlayer serverPlayer, int elapsedTicks) {
        Level level = serverPlayer.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 deltaMovement = serverPlayer.getDeltaMovement();
            if (deltaMovement.lengthSqr() > 0.01) {
                this.spawnSlimeParticles(serverLevel, serverPlayer);
                if (elapsedTicks - this.lastSoundTick >= 20) {
                    serverLevel.playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), SoundEvents.SLIME_BLOCK_STEP, SoundSource.PLAYERS, 0.5f, 1.0f + (serverLevel.random.nextFloat() - 0.5f) * 0.2f);
                    this.lastSoundTick = elapsedTicks;
                }
            }
            if (elapsedTicks > 0 && elapsedTicks % 40 == 0) {
                this.dropSlimeballBehindPlayer(serverLevel, serverPlayer, deltaMovement);
            }
        }
    }

    @Override
    public void onStart(ServerPlayer serverPlayer) {
        this.lastSoundTick = 0;
    }

    @Override
    public void onEnd(ServerPlayer serverPlayer) {
    }

    private void spawnSlimeParticles(ServerLevel level, ServerPlayer player) {
        for (int i = 0; i < 3; ++i) {
            double offsetX = (level.random.nextDouble() - 0.5) * 0.5;
            double offsetY = level.random.nextDouble() * 0.3;
            double offsetZ = (level.random.nextDouble() - 0.5) * 0.5;
            level.sendParticles((ParticleOptions)ParticleTypes.ITEM_SLIME, player.getX() + offsetX, player.getY() + offsetY, player.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void dropSlimeballBehindPlayer(ServerLevel serverLevel, ServerPlayer serverPlayer, Vec3 deltaMovement) {
        Vec3 dropPosition;
        if (deltaMovement.lengthSqr() > 0.01) {
            Vec3 normalizedMovement = deltaMovement.normalize();
            dropPosition = new Vec3(serverPlayer.getX() - normalizedMovement.x, serverPlayer.getY(), serverPlayer.getZ() - normalizedMovement.z);
        } else {
            Vec3 lookDirection = serverPlayer.getLookAngle();
            dropPosition = new Vec3(serverPlayer.getX() - lookDirection.x, serverPlayer.getY(), serverPlayer.getZ() - lookDirection.z);
        }
        ItemStack slimeball = new ItemStack((ItemLike)Items.SLIME_BALL, 1);
        ItemEntity itemEntity = new ItemEntity((Level)serverLevel, dropPosition.x, dropPosition.y, dropPosition.z, slimeball);
        itemEntity.setDefaultPickUpDelay();
        serverLevel.addFreshEntity((Entity)itemEntity);
    }
}

