/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item;

import de.markusbordihn.cookiescandyandcakes.data.minicakes.MiniCakeType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public abstract class BaseMiniCake
extends Item {
    protected final MiniCakeType miniCakeType;

    protected BaseMiniCake(MiniCakeType miniCakeType) {
        super(new Item.Properties().food(BaseMiniCake.buildFoodProperties(miniCakeType)));
        this.miniCakeType = miniCakeType;
    }

    protected static FoodProperties buildFoodProperties(MiniCakeType miniCakeType) {
        return new FoodProperties.Builder().nutrition(miniCakeType.getNutrition()).build();
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.GRAY));
    }

    public boolean isFoil(ItemStack itemStack) {
        return false;
    }
}

