/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item.variants;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieSoundType;
import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.effect.cookie.CookieClientEffectManager;
import de.markusbordihn.cookiescandyandcakes.effect.cookie.CookieServerEffectManager;
import de.markusbordihn.cookiescandyandcakes.item.base.BaseSpecialCookie;
import de.markusbordihn.cookiescandyandcakes.item.base.IdentifiableCookie;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CursedCookie
extends BaseSpecialCookie
implements IdentifiableCookie {
    public CursedCookie(CookieType cookieType) {
        super(cookieType);
    }

    @Override
    public CookieType getCookieType() {
        return this.cookieType;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        this.onConsume(livingEntity);
        this.applyCookieEffects(level, livingEntity);
        if (!level.isClientSide) {
            this.applySpecialEffects(level, livingEntity);
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    private void applyCookieEffects(Level level, LivingEntity livingEntity) {
        if (!level.isClientSide) {
            this.spawnParticles(level, livingEntity);
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                CookieServerEffectManager.applyCookieEffect(serverPlayer, this.cookieType);
            }
        } else if (livingEntity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)livingEntity;
            CookieClientEffectManager.applyCookieEffect(localPlayer, this.cookieType);
        }
    }

    private void applySpecialEffects(Level level, LivingEntity livingEntity) {
        CookieType.SpecialCookieEffect effect = this.cookieType.getSpecialCookieEffect();
        if (!effect.hasEffects()) {
            return;
        }
        this.spawnLightningIfNeeded(level, livingEntity, effect);
        this.playSoundIfEnabled(level, livingEntity, effect);
        this.applyDarknessIfNeeded(livingEntity, effect);
    }

    private void spawnLightningIfNeeded(Level level, LivingEntity livingEntity, CookieType.SpecialCookieEffect effect) {
        if (level.random.nextFloat() < effect.lightningChance()) {
            LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
            if (lightning == null) {
                return;
            }
            lightning.moveTo(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
            lightning.setVisualOnly(true);
            level.addFreshEntity((Entity)lightning);
        }
    }

    private void playSoundIfEnabled(Level level, LivingEntity livingEntity, CookieType.SpecialCookieEffect effect) {
        if (!effect.enableSounds()) {
            return;
        }
        this.playCursedSound(level, livingEntity, effect);
    }

    private void playCursedSound(Level level, LivingEntity livingEntity, CookieType.SpecialCookieEffect effect) {
        SoundEvent sound = CookieSoundType.getCursedSound(effect.cursedSoundType());
        if (sound == null) {
            return;
        }
        level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), sound, SoundSource.PLAYERS, effect.soundVolume(), CookieSoundType.getPitch(effect.cursedSoundType(), level.random.nextFloat()));
    }

    private void applyDarknessIfNeeded(LivingEntity livingEntity, CookieType.SpecialCookieEffect effect) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (effect.darknessEffectDuration() > 0) {
                player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, effect.darknessEffectDuration(), 0, false, false, false));
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add(this.getIdentifiedTooltip());
    }

    public Component getName(ItemStack stack) {
        return this.getUnidentifiedName();
    }
}

