/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.menu;

import de.markusbordihn.cookiescandyandcakes.block.entity.CookieJarBlockEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MenuManager {
    private static final Logger log = LogManager.getLogger((String)"CookiesCandyAndCakes");
    private static MenuOpener menuOpener;

    private MenuManager() {
    }

    public static void setMenuOpener(MenuOpener opener) {
        if (menuOpener != null) {
            log.warn("MenuOpener already set! Overwriting with: {}", (Object)opener.getClass().getSimpleName());
        }
        menuOpener = opener;
        log.info("MenuOpener initialized: {}", (Object)opener.getClass().getSimpleName());
    }

    public static void openCookieJarMenu(ServerPlayer player, CookieJarBlockEntity blockEntity) {
        if (menuOpener == null) {
            log.error("MenuOpener not initialized! Call setMenuOpener() during mod initialization.");
            return;
        }
        menuOpener.openCookieJarBlockEntityMenu(player, blockEntity);
    }

    public static void openCookieJarMenu(ServerPlayer player, ItemStack itemStack, InteractionHand hand) {
        if (menuOpener == null) {
            log.error("MenuOpener not initialized! Call setMenuOpener() during mod initialization.");
            return;
        }
        menuOpener.openCookieJarItemMenu(player, itemStack, hand);
    }

    public static interface MenuOpener {
        public void openCookieJarBlockEntityMenu(ServerPlayer var1, CookieJarBlockEntity var2);

        public void openCookieJarItemMenu(ServerPlayer var1, ItemStack var2, InteractionHand var3);
    }
}

