/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.block;

import com.mojang.serialization.MapCodec;
import de.markusbordihn.cookiescandyandcakes.block.entity.CookieJarBlockEntity;
import de.markusbordihn.cookiescandyandcakes.data.cookiejar.CookieJarData;
import de.markusbordihn.cookiescandyandcakes.menu.MenuManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class CookieJarBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    protected CookieJarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    private void openCookieJarMenu(ServerPlayer serverPlayer, CookieJarBlockEntity cookieJarBlockEntity) {
        MenuManager.openCookieJarMenu(serverPlayer, cookieJarBlockEntity);
    }

    protected abstract MapCodec<? extends CookieJarBlock> codec();

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CookieJarBlockEntity(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CookieJarBlockEntity) {
                CookieJarBlockEntity cookieJarBlockEntity = (CookieJarBlockEntity)blockEntity;
                this.openCookieJarMenu(serverPlayer, cookieJarBlockEntity);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult hitResult) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof CookieJarBlockEntity) {
                CookieJarBlockEntity cookieJarBlockEntity = (CookieJarBlockEntity)blockEntity;
                this.openCookieJarMenu(serverPlayer, cookieJarBlockEntity);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity != null) {
                level.removeBlockEntity(pos);
            }
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof CookieJarBlockEntity) {
            CookieJarBlockEntity cookieJarBlockEntity = (CookieJarBlockEntity)blockEntity;
            ItemStack itemStack = new ItemStack((ItemLike)this);
            cookieJarBlockEntity.saveToItem(itemStack, (HolderLookup.Provider)cookieJarBlockEntity.getLevel().registryAccess());
            if (!itemStack.isEmpty()) {
                drops.add(itemStack);
            }
        } else {
            drops.add(new ItemStack((ItemLike)this));
        }
        return drops;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof CookieJarBlockEntity) {
            CookieJarBlockEntity entity = (CookieJarBlockEntity)blockEntity;
            CookieJarData data = CookieJarData.fromItemStack(stack);
            for (int i = 0; i < data.items().size(); ++i) {
                entity.setItem(i, (ItemStack)data.items().get(i));
            }
            entity.setChanged();
        }
    }
}

