/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.block.entity;

import de.markusbordihn.cookiescandyandcakes.data.cookiejar.CookieJarData;
import de.markusbordihn.cookiescandyandcakes.menu.CookieJarMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CookieJarBlockEntity
extends BlockEntity
implements Container,
MenuProvider {
    public static final String COOKIE_JAR_DATA_TAG = "cookiejar_data";
    public static BlockEntityType<CookieJarBlockEntity> TYPE;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);

    public CookieJarBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.cookies_candy_and_cakes.cookie_jar");
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new CookieJarMenu(containerId, playerInventory, this);
    }

    public int getContainerSize() {
        return 27;
    }

    public boolean isEmpty() {
        for (ItemStack item : this.items) {
            if (item.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return slot >= 0 && slot < this.items.size() ? (ItemStack)this.items.get(slot) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = (ItemStack)this.items.get(slot);
        if (!stack.isEmpty()) {
            if (stack.getCount() <= amount) {
                this.items.set(slot, (Object)ItemStack.EMPTY);
                this.setChanged();
                return stack;
            }
            ItemStack result = stack.split(amount);
            this.setChanged();
            return result;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        if (slot >= 0 && slot < this.items.size()) {
            ItemStack stack = (ItemStack)this.items.get(slot);
            this.items.set(slot, (Object)ItemStack.EMPTY);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack itemStack) {
        if (slot >= 0 && slot < this.items.size()) {
            this.items.set(slot, (Object)itemStack);
            if (itemStack.getCount() > this.getMaxStackSize()) {
                itemStack.setCount(this.getMaxStackSize());
            }
            this.setChanged();
        }
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.items.clear();
        this.items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
        this.setChanged();
    }

    public void saveToItem(ItemStack itemStack, HolderLookup.Provider registries) {
        super.saveToItem(itemStack, registries);
        CookieJarData data = new CookieJarData(this.items);
        data.saveToItemStack(itemStack);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider registries) {
        super.saveAdditional(compoundTag, registries);
        CookieJarData data = new CookieJarData(this.items);
        ItemStack tempStack = new ItemStack((ItemLike)this.getBlockState().getBlock());
        data.saveToItemStack(tempStack);
        compoundTag.put(COOKIE_JAR_DATA_TAG, tempStack.save(registries));
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider registries) {
        super.loadAdditional(compoundTag, registries);
        if (compoundTag.contains(COOKIE_JAR_DATA_TAG)) {
            ItemStack tempStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compoundTag.getCompound(COOKIE_JAR_DATA_TAG));
            CookieJarData data = CookieJarData.fromItemStack(tempStack);
            this.items = data.items();
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }
}

