/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.cookiescandyandcakes.item.BaseCandy;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CandyChargeOverlay
implements LayeredDraw.Layer {
    private static final int BAR_WIDTH = 120;
    private static final int BAR_HEIGHT = 10;
    private static final int BAR_COLOR_BG = 0x60000000;
    private static final int BAR_COLOR_BG_BORDER = -1879048192;
    private static final int BAR_COLOR_WEAK = -520115712;
    private static final int BAR_COLOR_WEAK_SHINE = 1627381128;
    private static final int BAR_COLOR_STRONG = -520107008;
    private static final int BAR_COLOR_STRONG_SHINE = 1627389832;
    private static final int TEXT_COLOR = -1;
    private static final int TEXT_SHADOW_COLOR = Integer.MIN_VALUE;

    public static void renderCandyChargeBar(GuiGraphics guiGraphics, Minecraft minecraft) {
        MutableComponent text;
        float progress;
        if (minecraft.player == null || !minecraft.player.isUsingItem()) {
            return;
        }
        ItemStack activeStack = minecraft.player.getUseItem();
        if (!(activeStack.getItem() instanceof BaseCandy)) {
            return;
        }
        int usedTicks = activeStack.getUseDuration((LivingEntity)minecraft.player) - minecraft.player.getUseItemRemainingTicks();
        if (usedTicks < BaseCandy.getShowBarMinTicks() || usedTicks >= BaseCandy.getEatStartTicks()) {
            return;
        }
        if (CandyChargeOverlay.shouldEatDirectly((Player)minecraft.player)) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int barColor = -520107008;
        int shineColor = 1627389832;
        if (usedTicks >= BaseCandy.getPauseTicks()) {
            progress = 1.0f;
            text = Component.translatable((String)"item.cookies_candy_and_cakes.candy.throw_strong");
        } else if (usedTicks >= BaseCandy.getThrowMaxTicks()) {
            maxChargeTicks = BaseCandy.getThrowMaxTicks() - BaseCandy.getThrowMinTicks();
            progress = Math.min(1.0f, (float)(Math.min(usedTicks, BaseCandy.getThrowMaxTicks()) - BaseCandy.getThrowMinTicks()) / (float)maxChargeTicks);
            text = Component.translatable((String)"item.cookies_candy_and_cakes.candy.throw_strong");
        } else {
            maxChargeTicks = BaseCandy.getThrowMaxTicks() - BaseCandy.getThrowMinTicks();
            progress = Math.min(1.0f, (float)(usedTicks - BaseCandy.getThrowMinTicks()) / (float)maxChargeTicks);
            barColor = -520115712;
            shineColor = 1627381128;
            text = Component.translatable((String)"item.cookies_candy_and_cakes.candy.throw_weak");
        }
        int x = (minecraft.getWindow().getGuiScaledWidth() - 120) / 2;
        int y = minecraft.getWindow().getGuiScaledHeight() - 80;
        guiGraphics.fill(x - 1, y - 1, x + 120 + 1, y + 10 + 1, -1879048192);
        guiGraphics.fill(x, y, x + 120, y + 10, 0x60000000);
        int filledWidth = (int)(120.0f * progress);
        if (filledWidth > 0) {
            guiGraphics.fill(x, y, x + filledWidth, y + 10, barColor);
            guiGraphics.fill(x, y, x + filledWidth, y + 3, shineColor);
        }
        Font font = minecraft.font;
        int textX = x + (120 - font.width((FormattedText)text)) / 2;
        Objects.requireNonNull(font);
        int textY = y - 9 - 2;
        guiGraphics.drawString(font, (Component)text, textX + 1, textY + 1, Integer.MIN_VALUE, false);
        guiGraphics.drawString(font, (Component)text, textX, textY, -1, false);
        RenderSystem.disableBlend();
    }

    private static boolean shouldEatDirectly(Player player) {
        if (player.getXRot() < 45.0f) {
            return false;
        }
        Vec3 eyePos = player.getEyePosition();
        Vec3 lookVec = player.getLookAngle();
        Vec3 endPos = eyePos.add(lookVec.scale(2.5));
        BlockHitResult hitResult = player.level().clip(new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        return hitResult.getType() == HitResult.Type.BLOCK && !player.level().getBlockState(hitResult.getBlockPos()).isAir();
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        CandyChargeOverlay.renderCandyChargeBar(guiGraphics, Minecraft.getInstance());
    }
}

