/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect.candy;

import de.markusbordihn.cookiescandyandcakes.data.candies.CandyType;
import de.markusbordihn.cookiescandyandcakes.effect.ClientEffectInterface;
import de.markusbordihn.cookiescandyandcakes.effect.ClientEffectManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.player.LocalPlayer;

public class CandyClientEffectManager
extends ClientEffectManager {
    private static final Map<CandyType, ClientEffectInterface> CANDY_EFFECTS = new HashMap<CandyType, ClientEffectInterface>();
    private static final CandyClientEffectManager INSTANCE = new CandyClientEffectManager();

    private CandyClientEffectManager() {
    }

    public static CandyClientEffectManager getInstance() {
        return INSTANCE;
    }

    public static void applyCandyEffect(LocalPlayer player, CandyType candyType) {
        if (player == null || candyType == null) {
            return;
        }
        ClientEffectInterface effect = CANDY_EFFECTS.get((Object)candyType);
        if (effect != null) {
            CandyClientEffectManager.getInstance().applyEffect(player, effect);
        }
    }

    public static void tickPlayer(LocalPlayer player) {
        CandyClientEffectManager.getInstance().tick(player);
    }

    public static void removeCandyEffect(LocalPlayer player) {
        CandyClientEffectManager.getInstance().removeEffect(player);
    }

    public static void clearAllEffects() {
        CandyClientEffectManager.getInstance().clearAll();
    }

    public static boolean hasCandyEffect(LocalPlayer player) {
        return CandyClientEffectManager.getInstance().hasActiveEffect(player);
    }
}

