/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect.candy;

import de.markusbordihn.cookiescandyandcakes.data.candies.CandyType;
import de.markusbordihn.cookiescandyandcakes.effect.ServerEffectInterface;
import de.markusbordihn.cookiescandyandcakes.effect.ServerEffectManager;
import de.markusbordihn.cookiescandyandcakes.effect.candy.server.ChorusCandyCursedEffect;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;

public class CandyServerEffectManager
extends ServerEffectManager {
    private static final Map<CandyType, ServerEffectInterface> CANDY_EFFECTS = new HashMap<CandyType, ServerEffectInterface>();
    private static final CandyServerEffectManager INSTANCE = new CandyServerEffectManager();

    private CandyServerEffectManager() {
    }

    public static CandyServerEffectManager getInstance() {
        return INSTANCE;
    }

    public static void applyCandyEffect(ServerPlayer player, CandyType candyType) {
        if (player == null || candyType == null) {
            return;
        }
        ServerEffectInterface effect = CANDY_EFFECTS.get((Object)candyType);
        if (effect != null) {
            CandyServerEffectManager.getInstance().applyEffect(player, effect);
        }
    }

    public static void tickPlayer(ServerPlayer player) {
        CandyServerEffectManager.getInstance().tick(player);
    }

    public static void tickPlayers(Iterable<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            CandyServerEffectManager.tickPlayer(player);
        }
    }

    public static void removeCandyEffect(ServerPlayer player) {
        CandyServerEffectManager.getInstance().removeEffect(player);
    }

    public static void clearAllEffects() {
        CandyServerEffectManager.getInstance().clearAll();
    }

    public static boolean hasCandyEffect(ServerPlayer player) {
        return CandyServerEffectManager.getInstance().hasActiveEffect(player);
    }

    static {
        CANDY_EFFECTS.put(CandyType.CHORUS_CANDY_CURSED, new ChorusCandyCursedEffect());
    }
}

