/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect.candy.server;

import de.markusbordihn.cookiescandyandcakes.effect.ServerEffectInterface;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ChorusCandyCursedEffect
implements ServerEffectInterface {
    private static final int MAX_TELEPORT_DISTANCE = 16;
    private static final int MAX_TELEPORT_ATTEMPTS = 16;
    private static final int EFFECT_DURATION = 200;
    private static final int TELEPORT_INTERVAL = 20;
    private static final Map<UUID, Vec3> START_POSITIONS = new HashMap<UUID, Vec3>();

    @Override
    public int getDuration() {
        return 200;
    }

    @Override
    public void tick(ServerPlayer player, int elapsedTicks) {
        Level level;
        if (elapsedTicks % 20 == 0 && (level = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.teleportRandomly(serverLevel, player);
        }
    }

    @Override
    public void onStart(ServerPlayer player) {
        START_POSITIONS.put(player.getUUID(), player.position());
    }

    @Override
    public void onEnd(ServerPlayer player) {
        Level level;
        Vec3 startPos = START_POSITIONS.remove(player.getUUID());
        if (startPos != null && (level = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.teleportTo(serverLevel, player, startPos.x, startPos.y, startPos.z);
            serverLevel.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private void teleportRandomly(ServerLevel level, ServerPlayer player) {
        double originalX = player.getX();
        double originalY = player.getY();
        double originalZ = player.getZ();
        for (int attempt = 0; attempt < 16; ++attempt) {
            double deltaZ;
            double targetZ;
            double deltaY;
            double targetY;
            double deltaX = (level.random.nextDouble() - 0.5) * 2.0 * 16.0;
            double targetX = originalX + deltaX;
            if (!this.teleportTo(level, player, targetX, targetY = originalY + (deltaY = (double)(level.random.nextInt(16) - 8)), targetZ = originalZ + (deltaZ = (level.random.nextDouble() - 0.5) * 2.0 * 16.0))) continue;
            level.playSound(null, originalX, originalY, originalZ, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.resetFallDistance();
            return;
        }
    }

    private boolean teleportTo(ServerLevel level, ServerPlayer player, double x, double y, double z) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(x, y, z);
        while (mutablePos.getY() > level.getMinBuildHeight() && level.getBlockState((BlockPos)mutablePos).isAir()) {
            mutablePos.move(0, -1, 0);
        }
        BlockPos targetPos = mutablePos.immutable();
        BlockPos abovePos = targetPos.above();
        BlockPos abovePos2 = abovePos.above();
        if (level.getBlockState(targetPos).isAir() || !level.getBlockState(abovePos).isAir() || !level.getBlockState(abovePos2).isAir()) {
            return false;
        }
        Vec3 targetVec = Vec3.atBottomCenterOf((Vec3i)abovePos);
        return player.randomTeleport(targetVec.x, targetVec.y, targetVec.z, true);
    }
}

