/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.entity;

import de.markusbordihn.cookiescandyandcakes.data.candies.CandyType;
import de.markusbordihn.cookiescandyandcakes.item.BaseCandy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownCandy
extends ThrowableItemProjectile {
    public ThrownCandy(EntityType<? extends ThrownCandy> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownCandy(EntityType<? extends ThrownCandy> entityType, Level level, LivingEntity shooter) {
        super(entityType, shooter, level);
    }

    protected Item getDefaultItem() {
        return ItemStack.EMPTY.getItem();
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity entity;
        super.onHitEntity(entityHitResult);
        if (!this.level().isClientSide && (entity = entityHitResult.getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            boolean hasEffect = this.applyCandyEffect(target);
            Vec3 location = entityHitResult.getLocation();
            this.spawnImpactEffects(location);
            if (!hasEffect) {
                this.dropDefaultItem(this.level(), new BlockPos((int)location.x, (int)location.y, (int)location.z));
            }
        }
        this.discard();
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                BlockPos placePos = blockHitResult.getBlockPos().relative(blockHitResult.getDirection());
                this.spawnImpactEffects(hitResult.getLocation());
                this.dropDefaultItem(this.level(), placePos);
            }
            this.discard();
        }
    }

    private void spawnImpactEffects(Vec3 location) {
        Level level = this.level();
        ItemStack itemStack = this.getItem();
        if (!itemStack.isEmpty()) {
            for (int i = 0; i < 8; ++i) {
                level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemStack), location.x, location.y, location.z, ((double)level.random.nextFloat() - 0.5) * 0.2, (double)level.random.nextFloat() * 0.2, ((double)level.random.nextFloat() - 0.5) * 0.2);
            }
        }
        level.playSound(null, new BlockPos((int)location.x, (int)location.y, (int)location.z), SoundEvents.HONEY_BLOCK_BREAK, SoundSource.NEUTRAL, 0.8f, 1.2f + level.random.nextFloat() * 0.4f);
    }

    private void dropDefaultItem(Level level, BlockPos blockPos) {
        ItemStack itemStack = this.getItem();
        if (itemStack == null || itemStack.isEmpty()) {
            return;
        }
        ItemEntity droppedItem = new ItemEntity(level, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, new ItemStack((ItemLike)itemStack.getItem()));
        droppedItem.setDeltaMovement((double)((level.random.nextFloat() - 0.5f) * 0.3f), 0.25, (double)((level.random.nextFloat() - 0.5f) * 0.3f));
        level.addFreshEntity((Entity)droppedItem);
    }

    private boolean applyCandyEffect(LivingEntity target) {
        BaseCandy candy;
        CandyType candyType;
        ItemStack stack = this.getItem();
        Item item = stack.getItem();
        if (item instanceof BaseCandy && (candyType = (candy = (BaseCandy)item).getCandyType()).hasEffect()) {
            target.addEffect(new MobEffectInstance(candyType.getEffect(), candyType.getEffectDuration(), candyType.getAmplifier()));
            return true;
        }
        return false;
    }
}

