/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item;

import de.markusbordihn.cookiescandyandcakes.data.candies.CandyType;
import de.markusbordihn.cookiescandyandcakes.entity.ThrownCandy;
import de.markusbordihn.cookiescandyandcakes.registry.ModEntityTypes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class BaseCandy
extends Item {
    private static final int STACK_SIZE = 16;
    private static final int THROW_MIN_TICKS = 2;
    private static final int SHOW_BAR_MIN_TICKS = 5;
    private static final int THROW_MAX_TICKS = 20;
    private static final int PAUSE_TICKS = 22;
    private static final int EAT_START_TICKS = 27;
    private static final int USE_DURATION_TICKS = 55;
    private static final float THROW_MIN_VELOCITY = 0.5f;
    private static final float THROW_MAX_VELOCITY = 1.5f;
    private static final float THROW_INACCURACY = 1.0f;
    private static final float LOOK_DOWN_ANGLE = 45.0f;
    protected final CandyType candyType;

    protected BaseCandy(CandyType candyType) {
        super(new Item.Properties().food(BaseCandy.buildFoodProperties(candyType)).stacksTo(16));
        this.candyType = candyType;
    }

    protected static FoodProperties buildFoodProperties(CandyType candyType) {
        FoodProperties.Builder builder = new FoodProperties.Builder().nutrition(candyType.getNutrition()).fast();
        if (candyType.hasEffect()) {
            builder.effect(new MobEffectInstance(candyType.getEffect(), candyType.getEffectDuration(), candyType.getAmplifier()), candyType.getEffectChance());
        }
        return builder.build();
    }

    public static int getThrowMinTicks() {
        return 2;
    }

    public static int getShowBarMinTicks() {
        return 5;
    }

    public static int getThrowMaxTicks() {
        return 20;
    }

    public static int getPauseTicks() {
        return 22;
    }

    public static int getEatStartTicks() {
        return 27;
    }

    public CandyType getCandyType() {
        return this.candyType;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    private boolean shouldEatDirectly(Player player) {
        if (player.getXRot() < 45.0f) {
            return false;
        }
        Vec3 eyePos = player.getEyePosition();
        BlockHitResult hitResult = player.level().clip(new ClipContext(eyePos, eyePos.add(player.getLookAngle().scale(2.5)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        return hitResult.getType() == HitResult.Type.BLOCK && !player.level().getBlockState(hitResult.getBlockPos()).isAir();
    }

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity entity, int timeLeft) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int useDuration = this.getUseDuration(itemStack, entity);
        int usedTicks = useDuration - timeLeft;
        if (usedTicks < 2 || usedTicks >= 27) {
            return;
        }
        if (!this.shouldEatDirectly(player)) {
            float velocity = this.calculateThrowVelocity(usedTicks);
            this.throwCandy(level, player, itemStack, velocity);
        }
    }

    private float calculateThrowVelocity(int usedTicks) {
        if (usedTicks < 2) {
            return 0.5f;
        }
        if (usedTicks >= 20) {
            return 1.5f;
        }
        int chargeTicks = usedTicks - 2;
        int maxChargeTicks = 18;
        float chargeProgress = (float)chargeTicks / (float)maxChargeTicks;
        return 0.5f + 1.0f * chargeProgress;
    }

    private void throwCandy(Level level, Player player, ItemStack itemStack, float velocity) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            ThrownCandy thrownCandy = new ThrownCandy(ModEntityTypes.THROWN_CANDY.get(), level, (LivingEntity)player);
            thrownCandy.setItem(itemStack.copyWithCount(1));
            thrownCandy.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, velocity, 1.0f);
            level.addFreshEntity((Entity)thrownCandy);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return super.finishUsingItem(itemStack, level, entity);
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return 55;
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.EAT;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag flag) {
        tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.DARK_GRAY));
    }

    public boolean isFoil(ItemStack itemStack) {
        return this.candyType.getVariant() == CandyType.CandyVariant.MYSTIC;
    }
}

