/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public abstract class BaseCookie
extends Item {
    private static final int STACK_SIZE = 64;
    protected final CookieType cookieType;

    protected BaseCookie(CookieType cookieType) {
        super(new Item.Properties().food(BaseCookie.buildFoodProperties(cookieType)).stacksTo(64));
        this.cookieType = cookieType;
    }

    protected static FoodProperties buildFoodProperties(CookieType cookieType) {
        FoodProperties.Builder builder = new FoodProperties.Builder().nutrition(cookieType.getNutrition()).fast();
        if (cookieType.hasEffect()) {
            builder.effect(new MobEffectInstance(cookieType.getEffect(), cookieType.getEffectDuration(), cookieType.getAmplifier()), cookieType.getEffectChance());
        }
        return builder.build();
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.DARK_GRAY));
    }

    public boolean isFoil(ItemStack itemStack) {
        return this.cookieType.getVariant() == CookieType.CookieVariant.MYSTIC;
    }
}

