/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item.base;

import de.markusbordihn.cookiescandyandcakes.data.candies.CandyType;
import de.markusbordihn.cookiescandyandcakes.effect.candy.CandyClientEffectManager;
import de.markusbordihn.cookiescandyandcakes.effect.candy.CandyServerEffectManager;
import de.markusbordihn.cookiescandyandcakes.item.BaseCandy;
import de.markusbordihn.cookiescandyandcakes.item.base.BaseSpecialItem;
import de.markusbordihn.cookiescandyandcakes.item.base.IdentifiableCandy;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class BaseSpecialCandy
extends BaseCandy
implements BaseSpecialItem<IdentifiableCandy> {
    protected BaseSpecialCandy(CandyType candyType) {
        super(candyType);
    }

    @Override
    public IdentifiableCandy getIdentifiable() {
        return (IdentifiableCandy)((Object)this);
    }

    @Override
    public void applyEffects(Level level, LivingEntity entity) {
        if (!level.isClientSide) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CandyServerEffectManager.applyCandyEffect(serverPlayer, this.candyType);
            }
        } else if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            CandyClientEffectManager.applyCandyEffect(localPlayer, this.candyType);
        }
    }

    @Override
    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity entity) {
        BaseSpecialItem.super.finishUsingItem(itemStack, level, entity);
        return super.finishUsingItem(itemStack, level, entity);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        BaseSpecialItem.super.appendHoverText(itemStack, tooltipComponents, tooltipFlag);
    }

    @Override
    public Component getName(ItemStack itemStack) {
        return BaseSpecialItem.super.getName(itemStack);
    }

    @Override
    public boolean isFoil(ItemStack itemStack) {
        return true;
    }
}

