/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item.base;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public interface IdentifiableItem<T> {
    public T getItemType();

    public String getDescriptionId();

    public boolean hasIdentified(T var1);

    public void markAsIdentified(T var1);

    public ChatFormatting getVariantColor(T var1);

    public String getUnidentifiedBaseKey();

    default public Component getUnidentifiedName() {
        if (this.hasIdentified(this.getItemType())) {
            return Component.translatable((String)this.getDescriptionId()).withStyle(this.getVariantColor(this.getItemType()));
        }
        return Component.translatable((String)this.getUnidentifiedKey()).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_PURPLE).withObfuscated(Boolean.valueOf(true)));
    }

    default public Component getIdentifiedTooltip() {
        if (this.hasIdentified(this.getItemType())) {
            return Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.DARK_GRAY);
        }
        return Component.translatable((String)this.getUnidentifiedDescKey()).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_PURPLE).withObfuscated(Boolean.valueOf(true)));
    }

    default public void onConsume(LivingEntity entity) {
        if (entity instanceof Player && entity.level().isClientSide) {
            this.markAsIdentified(this.getItemType());
        }
    }

    default public String getUnidentifiedKey() {
        return this.getUnidentifiedBaseKey();
    }

    default public String getUnidentifiedDescKey() {
        return this.getUnidentifiedKey() + ".desc";
    }
}

