/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.config;

import de.markusbordihn.cookiescandyandcakes.config.Config;
import de.markusbordihn.cookiescandyandcakes.data.minicakes.MiniCakeType;
import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;

public class MiniCakeConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "mini_cakes.cfg";
    public static final String CONFIG_FILE_HEADER = " Mini Cake Configuration\n\n This configuration file allows you to customize mini cake properties per type.\n\n General Settings:\n - nutrition: Food points restored (default: 3)\n\n You can configure these values globally or per mini cake type by prefixing with the mini cake type ID.\n Example: mini_apple_cake.nutrition = 4\n\n";
    private static final Map<MiniCakeType, Integer> nutritionOverrides = new EnumMap<MiniCakeType, Integer>(MiniCakeType.class);
    private static int defaultNutrition = 3;

    public static void registerConfig() {
        MiniCakeConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        MiniCakeConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = MiniCakeConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = MiniCakeConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        defaultNutrition = MiniCakeConfig.parseConfigValue(properties, "nutrition", defaultNutrition);
        nutritionOverrides.clear();
        for (MiniCakeType type : MiniCakeType.values()) {
            String camelCaseName = MiniCakeConfig.toCamelCase(type.getId());
            String prefix = "miniCake." + camelCaseName + ".";
            nutritionOverrides.put(type, MiniCakeConfig.parseConfigValue(properties, prefix + "nutrition", defaultNutrition));
        }
        MiniCakeConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static int getNutrition(MiniCakeType type) {
        return nutritionOverrides.getOrDefault((Object)type, defaultNutrition);
    }
}

