/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item.base;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.effect.cookie.CookieClientEffectManager;
import de.markusbordihn.cookiescandyandcakes.effect.cookie.CookieServerEffectManager;
import de.markusbordihn.cookiescandyandcakes.item.BaseCookie;
import de.markusbordihn.cookiescandyandcakes.item.base.BaseSpecialItem;
import de.markusbordihn.cookiescandyandcakes.item.base.IdentifiableCookie;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class BaseSpecialCookie
extends BaseCookie
implements BaseSpecialItem<IdentifiableCookie> {
    protected static final ParticleOptions[] SPECIAL_PARTICLES = new ParticleOptions[]{ParticleTypes.SOUL, ParticleTypes.SOUL_FIRE_FLAME, ParticleTypes.SMOKE, ParticleTypes.LARGE_SMOKE, ParticleTypes.WARPED_SPORE, ParticleTypes.CRIMSON_SPORE};

    protected BaseSpecialCookie(CookieType cookieType) {
        super(cookieType);
    }

    @Override
    public IdentifiableCookie getIdentifiable() {
        return (IdentifiableCookie)((Object)this);
    }

    @Override
    public void applyEffects(Level level, LivingEntity entity) {
        if (!level.isClientSide) {
            this.spawnParticles(level, entity);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CookieServerEffectManager.applyCookieEffect(serverPlayer, this.cookieType);
            }
        } else if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            CookieClientEffectManager.applyCookieEffect(localPlayer, this.cookieType);
        }
    }

    protected void spawnParticles(Level level, LivingEntity livingEntity) {
        int i;
        ParticleOptions particle = SPECIAL_PARTICLES[level.random.nextInt(SPECIAL_PARTICLES.length)];
        for (i = 0; i < 15; ++i) {
            double angle = Math.PI * 2 * (double)i / 15.0;
            double offsetX = Math.cos(angle) * 0.5;
            double offsetZ = Math.sin(angle) * 0.5;
            level.addParticle(particle, livingEntity.getX() + offsetX, livingEntity.getY() + 1.0, livingEntity.getZ() + offsetZ, 0.0, 0.1, 0.0);
        }
        for (i = 0; i < 10; ++i) {
            level.addParticle(particle, livingEntity.getX() + (level.random.nextDouble() - 0.5) * 1.5, livingEntity.getY() + level.random.nextDouble() * 2.0, livingEntity.getZ() + (level.random.nextDouble() - 0.5) * 1.5, (level.random.nextDouble() - 0.5) * 0.1, level.random.nextDouble() * 0.1, (level.random.nextDouble() - 0.5) * 0.1);
        }
    }

    @Override
    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity entity) {
        BaseSpecialItem.super.finishUsingItem(itemStack, level, entity);
        return super.finishUsingItem(itemStack, level, entity);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        BaseSpecialItem.super.appendHoverText(stack, tooltipComponents, tooltipFlag);
    }

    @Override
    public Component getName(ItemStack itemStack) {
        return BaseSpecialItem.super.getName(itemStack);
    }

    @Override
    public boolean isFoil(ItemStack itemStack) {
        return true;
    }
}

