/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item.variants;

import de.markusbordihn.cookiescandyandcakes.data.SpecialItemEffect;
import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieSoundType;
import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.item.base.BaseSpecialCookie;
import de.markusbordihn.cookiescandyandcakes.item.base.IdentifiableCookie;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MysticCookie
extends BaseSpecialCookie
implements IdentifiableCookie {
    public MysticCookie(CookieType cookieType) {
        super(cookieType);
    }

    @Override
    public CookieType getCookieType() {
        return this.cookieType;
    }

    @Override
    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity entity) {
        if (!level.isClientSide) {
            this.applySpecialEffects(level, entity);
        }
        return super.finishUsingItem(itemStack, level, entity);
    }

    private void applySpecialEffects(Level level, LivingEntity entity) {
        SpecialItemEffect effect = this.cookieType.getSpecialCookieEffect();
        if (!effect.hasEffects()) {
            return;
        }
        this.spawnLightningIfNeeded(level, entity, effect);
        this.playSoundIfEnabled(level, entity, effect);
    }

    private void spawnLightningIfNeeded(Level level, LivingEntity entity, SpecialItemEffect effect) {
        if (level.random.nextFloat() < effect.lightningChance()) {
            LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
            if (lightning == null) {
                return;
            }
            lightning.moveTo(entity.getX(), entity.getY(), entity.getZ());
            lightning.setVisualOnly(true);
            level.addFreshEntity((Entity)lightning);
        }
    }

    private void playSoundIfEnabled(Level level, LivingEntity entity, SpecialItemEffect effect) {
        SoundEvent sound;
        if (effect.enableSounds() && (sound = CookieSoundType.getMysticSound(effect.mysticSoundType())) != null) {
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), sound, SoundSource.PLAYERS, effect.soundVolume(), CookieSoundType.getPitch(effect.mysticSoundType(), level.random.nextFloat()));
        }
    }
}

