/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.data.cookiejar;

import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public record CookieJarData(NonNullList<ItemStack> items) {
    public static final int CONTAINER_SIZE = 27;

    public static CookieJarData fromItemStack(ItemStack stack) {
        ItemContainerContents contents = (ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        NonNullList items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
        contents.copyInto(items);
        return new CookieJarData((NonNullList<ItemStack>)items);
    }

    public void saveToItemStack(ItemStack stack) {
        if (!this.isEmpty()) {
            stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.items));
        } else {
            stack.remove(DataComponents.CONTAINER);
        }
    }

    public boolean isEmpty() {
        for (ItemStack item : this.items) {
            if (item.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

