/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item;

import de.markusbordihn.cookiescandyandcakes.menu.MenuManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CookieJarItem
extends BlockItem {
    public CookieJarItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuManager.openCookieJarMenu(serverPlayer, itemStack, hand);
            return InteractionResultHolder.success((Object)itemStack);
        }
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public boolean overrideStackedOnOther(ItemStack cookieJarStack, Slot slot, ClickAction action, Player player) {
        if (action == ClickAction.SECONDARY && !cookieJarStack.isEmpty()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MenuManager.openCookieJarMenu(serverPlayer, cookieJarStack, InteractionHand.MAIN_HAND);
            }
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipComponents, flag);
        String blockDescKey = this.getBlock().getDescriptionId() + ".desc";
        tooltipComponents.add((Component)Component.translatable((String)blockDescKey).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        tooltipComponents.add((Component)Component.translatable((String)"item.cookies_candy_and_cakes.cookie_jar.open_hint").withStyle(ChatFormatting.AQUA));
        ItemContainerContents contents = (ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        int itemCount = 0;
        int slotCount = 0;
        for (ItemStack item : contents.nonEmptyItems()) {
            if (item.isEmpty()) continue;
            itemCount += item.getCount();
            ++slotCount;
        }
        if (itemCount > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"item.cookies_candy_and_cakes.cookie_jar.contents", (Object[])new Object[]{itemCount, slotCount}).withStyle(ChatFormatting.GOLD));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.cookies_candy_and_cakes.cookie_jar.empty").withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }
}

