/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item.base;

import de.markusbordihn.cookiescandyandcakes.item.base.IdentifiableItem;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public interface BaseSpecialItem<T extends IdentifiableItem<?>> {
    public T getIdentifiable();

    public void applyEffects(Level var1, LivingEntity var2);

    default public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity entity) {
        this.getIdentifiable().onConsume(entity);
        this.applyEffects(level, entity);
        return itemStack;
    }

    default public void appendHoverText(ItemStack itemStack, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add(this.getIdentifiable().getIdentifiedTooltip());
    }

    default public Component getName(ItemStack itemStack) {
        return this.getIdentifiable().getUnidentifiedName();
    }
}

