/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.data.cookies;

import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;

public enum CookieType {
    APPLE_COOKIE(CookieVariant.NORMAL, null, 0),
    APPLE_COOKIE_MYSTIC(CookieVariant.MYSTIC, (Holder<MobEffect>)MobEffects.ABSORPTION, 0),
    APPLE_COOKIE_CURSED(CookieVariant.CURSED, (Holder<MobEffect>)MobEffects.POISON, 0),
    CARROT_COOKIE(CookieVariant.NORMAL, null, 0),
    CARROT_COOKIE_MYSTIC(CookieVariant.MYSTIC, (Holder<MobEffect>)MobEffects.NIGHT_VISION, 0),
    CARROT_COOKIE_CURSED(CookieVariant.CURSED, (Holder<MobEffect>)MobEffects.BLINDNESS, 0),
    GLOW_BERRY_COOKIE(CookieVariant.NORMAL, null, 0),
    GLOW_BERRY_COOKIE_MYSTIC(CookieVariant.MYSTIC, (Holder<MobEffect>)MobEffects.GLOWING, 0),
    GLOW_BERRY_COOKIE_CURSED(CookieVariant.CURSED, (Holder<MobEffect>)MobEffects.DARKNESS, 0),
    MELON_COOKIE(CookieVariant.NORMAL, null, 0),
    MELON_COOKIE_MYSTIC(CookieVariant.MYSTIC, (Holder<MobEffect>)MobEffects.REGENERATION, 0),
    MELON_COOKIE_CURSED(CookieVariant.CURSED, (Holder<MobEffect>)MobEffects.WITHER, 0),
    PUMPKIN_COOKIE(CookieVariant.NORMAL, null, 0),
    PUMPKIN_COOKIE_MYSTIC(CookieVariant.MYSTIC, (Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE, 0),
    PUMPKIN_COOKIE_CURSED(CookieVariant.CURSED, (Holder<MobEffect>)MobEffects.WEAKNESS, 1),
    SWEET_BERRY_COOKIE(CookieVariant.NORMAL, null, 0),
    SWEET_BERRY_COOKIE_MYSTIC(CookieVariant.MYSTIC, (Holder<MobEffect>)MobEffects.JUMP, 2),
    SWEET_BERRY_COOKIE_CURSED(CookieVariant.CURSED, (Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, 1);

    private final CookieVariant variant;
    private final Holder<MobEffect> effect;
    private final int amplifier;
    private final String id;

    private CookieType(CookieVariant variant, Holder<MobEffect> effect, int amplifier) {
        this.variant = variant;
        this.effect = effect;
        this.amplifier = amplifier;
        this.id = this.name().toLowerCase(Locale.ROOT);
    }

    public String getId() {
        return this.id;
    }

    public CookieVariant getVariant() {
        return this.variant;
    }

    public Holder<MobEffect> getEffect() {
        return this.effect;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public boolean hasEffect() {
        return this.effect != null;
    }

    public static enum CookieVariant {
        NORMAL,
        MYSTIC,
        CURSED;

    }
}

