/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.event;

import de.markusbordihn.cookiescandyandcakes.registry.ModItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MonsterLootHandler {
    private static final float DROP_CHANCE = 0.25f;
    private static final Item[] CANDY_CRUMB_ITEMS = new Item[]{ModItems.APPLE_COOKIE_MYSTIC, ModItems.APPLE_COOKIE_CURSED, ModItems.CARROT_COOKIE_MYSTIC, ModItems.CARROT_COOKIE_CURSED, ModItems.GLOW_BERRY_COOKIE_MYSTIC, ModItems.GLOW_BERRY_COOKIE_CURSED, ModItems.MELON_COOKIE_MYSTIC, ModItems.MELON_COOKIE_CURSED, ModItems.PUMPKIN_COOKIE_MYSTIC, ModItems.PUMPKIN_COOKIE_CURSED, ModItems.SWEET_BERRY_COOKIE_MYSTIC, ModItems.SWEET_BERRY_COOKIE_CURSED};

    private MonsterLootHandler() {
    }

    public static boolean shouldDropCandyCrumbs(Entity entity) {
        return entity instanceof Monster && entity.level().getRandom().nextFloat() < 0.25f;
    }

    public static ItemStack getRandomCandyCrumb(Entity entity) {
        Item item = CANDY_CRUMB_ITEMS[entity.level().getRandom().nextInt(CANDY_CRUMB_ITEMS.length)];
        return new ItemStack((ItemLike)item);
    }

    public static ItemEntity createCandyCrumbDrop(Entity entity) {
        return new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), MonsterLootHandler.getRandomCandyCrumb(entity));
    }
}

