/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class BaseSpookyCookie
extends Item {
    protected static final ParticleOptions[] SPOOKY_PARTICLES = new ParticleOptions[]{ParticleTypes.SOUL, ParticleTypes.SOUL_FIRE_FLAME, ParticleTypes.SMOKE, ParticleTypes.LARGE_SMOKE, ParticleTypes.WARPED_SPORE, ParticleTypes.CRIMSON_SPORE};

    protected BaseSpookyCookie(CookieType cookieType) {
        super(new Item.Properties().food(BaseSpookyCookie.buildFoodProperties(cookieType)).stacksTo(64));
    }

    private static FoodProperties buildFoodProperties(CookieType cookieType) {
        FoodProperties.Builder builder = new FoodProperties.Builder().nutrition(2).fast();
        if (cookieType.hasEffect()) {
            builder.effect(new MobEffectInstance(cookieType.getEffect(), 600, cookieType.getAmplifier()), 1.0f);
        }
        return builder.build();
    }

    protected void spawnParticles(Level level, LivingEntity livingEntity) {
        int i;
        ParticleOptions particle = SPOOKY_PARTICLES[level.random.nextInt(SPOOKY_PARTICLES.length)];
        for (i = 0; i < 15; ++i) {
            double angle = Math.PI * 2 * (double)i / 15.0;
            double offsetX = Math.cos(angle) * 0.5;
            double offsetZ = Math.sin(angle) * 0.5;
            level.addParticle(particle, livingEntity.getX() + offsetX, livingEntity.getY() + 1.0, livingEntity.getZ() + offsetZ, 0.0, 0.1, 0.0);
        }
        for (i = 0; i < 10; ++i) {
            level.addParticle(particle, livingEntity.getX() + (level.random.nextDouble() - 0.5) * 1.5, livingEntity.getY() + level.random.nextDouble() * 2.0, livingEntity.getZ() + (level.random.nextDouble() - 0.5) * 1.5, (level.random.nextDouble() - 0.5) * 0.1, level.random.nextDouble() * 0.1, (level.random.nextDouble() - 0.5) * 0.1);
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")));
    }

    public boolean isFoil(ItemStack itemStack) {
        return true;
    }
}

