/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.item.BaseSpookyCookie;
import de.markusbordihn.cookiescandyandcakes.item.IdentifiableCookie;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CandyCrumbItem
extends BaseSpookyCookie
implements IdentifiableCookie {
    private final CookieType cookieType;

    public CandyCrumbItem(CookieType cookieType) {
        super(cookieType);
        this.cookieType = cookieType;
    }

    @Override
    public CookieType getCookieType() {
        return this.cookieType;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        this.onConsume(livingEntity);
        if (!level.isClientSide) {
            this.spawnParticles(level, livingEntity);
            if (level.random.nextBoolean()) {
                LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                if (lightning != null) {
                    lightning.moveTo(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
                    lightning.setVisualOnly(true);
                    level.addFreshEntity((Entity)lightning);
                }
            } else {
                level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEvents.ENDER_DRAGON_AMBIENT, SoundSource.PLAYERS, 4.0f, 0.7f + level.random.nextFloat() * 0.3f);
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 60, 0, false, false, false));
                }
            }
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add(this.getIdentifiedTooltip());
    }

    public Component getName(ItemStack stack) {
        return this.getUnidentifiedName();
    }
}

