/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item;

import de.markusbordihn.cookiescandyandcakes.client.ClientCookieData;
import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public interface IdentifiableCookie {
    public CookieType getCookieType();

    public String getDescriptionId();

    default public Component getUnidentifiedName() {
        if (ClientCookieData.hasIdentified(this.getCookieType())) {
            return Component.translatable((String)this.getDescriptionId());
        }
        return Component.translatable((String)this.getUnidentifiedKey()).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_PURPLE).withObfuscated(Boolean.valueOf(true)));
    }

    default public Component getIdentifiedTooltip() {
        if (ClientCookieData.hasIdentified(this.getCookieType())) {
            return Component.translatable((String)(this.getDescriptionId() + ".desc"));
        }
        return Component.translatable((String)this.getUnidentifiedDescKey()).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_PURPLE).withObfuscated(Boolean.valueOf(true)));
    }

    default public void onConsume(LivingEntity entity) {
        if (entity instanceof Player && entity.level().isClientSide) {
            ClientCookieData.markAsIdentified(this.getCookieType());
        }
    }

    default public String getUnidentifiedKey() {
        return this.getCookieType().getVariant() == CookieType.CookieVariant.MYSTIC ? "item.cookies_candy_and_cakes.unidentified_mystic_cookie" : "item.cookies_candy_and_cakes.unidentified_cursed_cookie";
    }

    default public String getUnidentifiedDescKey() {
        return this.getUnidentifiedKey() + ".desc";
    }
}

