/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.config;

import de.markusbordihn.cookiescandyandcakes.Constants;
import de.markusbordihn.cookiescandyandcakes.config.CookieConfig;
import de.markusbordihn.cookiescandyandcakes.config.MonsterLootConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import net.minecraft.class_1814;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    protected static final Logger log = LogManager.getLogger((String)"Cookies, Candy and Cakes");
    private static final String LOG_PREFIX = "[Config]";
    private static boolean isLoaded = false;
    private static Path configPath = Paths.get("", new String[0]).toAbsolutePath().resolve("config").resolve("cookies_candy_and_cakes");

    protected Config() {
    }

    public static void register(boolean isServer) {
        Config.prepareConfiguration();
        Config.registerCommonConfig();
        if (isServer) {
            Config.registerServerConfig();
        }
    }

    public static void registerDeferred(boolean isServer) {
        Config.registerCommonConfigDeferred();
    }

    public static void registerCommonConfigDeferred() {
        log.info("{} Registering deferred common configuration ...", (Object)LOG_PREFIX);
    }

    public static void registerCommonConfig() {
        log.info("{} Registering common configuration ...", (Object)LOG_PREFIX);
        CookieConfig.registerConfig();
        MonsterLootConfig.registerConfig();
    }

    public static void registerServerConfig() {
        log.info("{} Registering server configuration ...", (Object)LOG_PREFIX);
    }

    public static void prepareConfiguration() {
        if (Constants.CONFIG_DIR != null) {
            configPath = Constants.CONFIG_DIR.resolve("cookies_candy_and_cakes");
            log.info("{} Updated configuration path to {}", (Object)LOG_PREFIX, (Object)configPath);
        }
        if (!configPath.toFile().exists()) {
            log.info("{} Creating configuration folder {}", (Object)LOG_PREFIX, (Object)Config.getConfigDirectory());
        }
        if (isLoaded) {
            log.error("{} Configuration is already loaded", (Object)LOG_PREFIX);
            log.warn("Check if configuration is loaded multiple times!");
            return;
        }
        isLoaded = true;
    }

    public static void registerConfigFile(String configFileName, String configFileHeader) {
        File configFile = Config.getConfigFile(configFileName.trim());
        if (configFile == null || !configFile.exists()) {
            Config.createConfigFile(Config.getConfigFile(configFileName.trim()), configFileHeader.trim());
        }
    }

    public static Properties readConfigFile(File configFile) {
        Properties properties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(configFile.toPath());){
            properties.load(reader);
        }
        catch (Exception e) {
            log.error("{} Failed to read configuration file {}:", (Object)LOG_PREFIX, (Object)configFile, (Object)e);
        }
        return properties;
    }

    public static void createConfigFile(File configFile, String header) {
        Properties properties = new Properties();
        log.info("{} Try creating configuration file {}", (Object)LOG_PREFIX, (Object)configFile);
        try (FileWriter writer = new FileWriter(configFile);){
            properties.store(writer, header.trim());
            log.info("{} Created configuration file {} ...", (Object)LOG_PREFIX, (Object)configFile);
        }
        catch (Exception e) {
            log.error("{} Failed to create configuration file {} for {}", (Object)LOG_PREFIX, (Object)configFile, (Object)properties);
        }
    }

    public static File getConfigFile(String configFileName) {
        Path path = Config.getConfigDirectory();
        if (path != null) {
            return path.resolve(configFileName).toFile();
        }
        return null;
    }

    private static Path getConfigDirectory() {
        Path resultPath = null;
        try {
            resultPath = Files.createDirectories(configPath, new FileAttribute[0]);
        }
        catch (Exception e) {
            log.error("{} Failed to create configuration folder {}:", (Object)LOG_PREFIX, (Object)configPath, (Object)e);
        }
        return resultPath;
    }

    public static void updateConfigFileIfChanged(File configFile, String configFileHeader, Properties properties, Properties unmodifiedProperties) {
        if (!properties.equals(unmodifiedProperties)) {
            log.info("{} Updating configuration file {} {}: {}", (Object)LOG_PREFIX, (Object)configFile, (Object)configFileHeader, (Object)properties);
            try (FileWriter writer = new FileWriter(configFile);){
                properties.store(writer, configFileHeader.trim());
            }
            catch (Exception e) {
                log.error("{} Failed to update configuration file {} with {}", (Object)LOG_PREFIX, (Object)configFile, (Object)properties);
            }
        } else if (properties.isEmpty()) {
            log.warn("{} Configuration file {} is empty: {}", (Object)LOG_PREFIX, (Object)configFile, (Object)properties);
        } else {
            log.info("{} {} is up to date: {}", (Object)LOG_PREFIX, (Object)configFileHeader, (Object)properties);
        }
    }

    protected static String parseConfigValue(Properties properties, String key, String defaultValue) {
        if (properties.containsKey(key)) {
            try {
                return properties.getProperty(key).trim();
            }
            catch (Exception e) {
                log.error("{} Failed to parse String value for key {}:", (Object)LOG_PREFIX, (Object)key, (Object)e);
            }
        }
        properties.setProperty(key, defaultValue);
        return defaultValue;
    }

    protected static class_1814 parseConfigValue(Properties properties, String key, class_1814 defaultValue) {
        if (properties.containsKey(key)) {
            try {
                return class_1814.valueOf((String)properties.getProperty(key).trim().toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                log.error("{} Failed to parse Rarity value for key {}:", (Object)LOG_PREFIX, (Object)key, (Object)e);
            }
        }
        properties.setProperty(key, defaultValue.name());
        return defaultValue;
    }

    protected static int parseConfigValue(Properties properties, String key, int defaultValue) {
        if (properties.containsKey(key)) {
            try {
                return Integer.parseInt(properties.getProperty(key).trim());
            }
            catch (Exception e) {
                log.error("{} Failed to parse Integer value for key {}:", (Object)LOG_PREFIX, (Object)key, (Object)e);
            }
        }
        properties.setProperty(key, Integer.toString(defaultValue));
        return defaultValue;
    }

    protected static float parseConfigValue(Properties properties, String key, float defaultValue) {
        if (properties.containsKey(key)) {
            try {
                return Float.parseFloat(properties.getProperty(key).trim());
            }
            catch (Exception e) {
                log.error("{} Failed to parse Float value for key {}:", (Object)LOG_PREFIX, (Object)key, (Object)e);
            }
        }
        properties.setProperty(key, Float.toString(defaultValue));
        return defaultValue;
    }

    protected static boolean parseConfigValue(Properties properties, String key, boolean defaultValue) {
        if (properties.containsKey(key)) {
            try {
                return Boolean.parseBoolean(properties.getProperty(key).trim());
            }
            catch (Exception e) {
                log.error("{} Failed to parse Boolean value for key {}:", (Object)LOG_PREFIX, (Object)key, (Object)e);
            }
        }
        properties.setProperty(key, Boolean.toString(defaultValue));
        return defaultValue;
    }

    protected static Set<String> parseConfigValue(Properties properties, String key, Set<String> defaultValue) {
        if (properties.containsKey(key)) {
            try {
                String value = properties.getProperty(key).trim();
                return value.isEmpty() ? Set.of() : Set.of(value.split(",\\s*"));
            }
            catch (Exception e) {
                log.error("{} Failed to parse Set[String] for key {}:", (Object)LOG_PREFIX, (Object)key, (Object)e);
            }
        }
        properties.setProperty(key, String.join((CharSequence)",", defaultValue));
        return defaultValue;
    }
}

