/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect.cookie.client;

import de.markusbordihn.cookiescandyandcakes.effect.ClientEffectInterface;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1548;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class CreeperCrunchCookieCursedEffectClient
implements ClientEffectInterface {
    private static final int CREEPER_SPAWN_DISTANCE = 8;
    private static final int CREEPER_SPAWN_TICK = 20;
    private static final int CREEPER_MOVE_DURATION = 120;
    private static final int CREEPER_EXPLODE_TICK = 140;
    private static final int SOUND_INTERVAL = 20;
    private final List<FakeCreeper> fakeCreepers = new ArrayList<FakeCreeper>();

    @Override
    public int getDuration() {
        return 150;
    }

    @Override
    public void tick(class_746 localPlayer, int elapsedTicks) {
        class_1937 class_19372 = localPlayer.method_37908();
        if (!(class_19372 instanceof class_638)) {
            return;
        }
        class_638 clientLevel = (class_638)class_19372;
        if (elapsedTicks == 20) {
            this.spawnFakeCreepers(clientLevel, localPlayer);
        } else if (elapsedTicks > 20 && elapsedTicks <= 140) {
            int progress = elapsedTicks - 20;
            if (progress % 20 == 0) {
                this.playCreeperSound(clientLevel, localPlayer.method_19538());
            }
            this.updateFakeCreepers(clientLevel, localPlayer);
        } else {
            this.explodeFakeCreepers(clientLevel);
        }
    }

    @Override
    public void onStart(class_746 localPlayer) {
        this.fakeCreepers.clear();
    }

    @Override
    public void onEnd(class_746 localPlayer) {
        class_1937 class_19372 = localPlayer.method_37908();
        if (class_19372 instanceof class_638) {
            class_638 clientLevel = (class_638)class_19372;
            this.removeFakeCreepers(clientLevel);
        }
        this.fakeCreepers.clear();
    }

    private void spawnFakeCreepers(class_638 level, class_746 player) {
        class_243 playerPos = player.method_19538();
        for (int i = 0; i < 4; ++i) {
            class_1548 creeper = (class_1548)class_1299.field_6046.method_5883((class_1937)level);
            if (creeper == null) continue;
            double angle = 1.5707963267948966 * (double)i;
            double offsetX = Math.cos(angle) * 8.0;
            double offsetZ = Math.sin(angle) * 8.0;
            creeper.method_56073(120);
            creeper.method_5814(playerPos.field_1352 + offsetX, playerPos.field_1351, playerPos.field_1350 + offsetZ);
            creeper.method_36456((float)Math.toDegrees(angle + Math.PI));
            creeper.field_5982 = creeper.method_36454();
            creeper.method_5847(creeper.method_36454());
            creeper.method_5875(true);
            creeper.method_5684(true);
            creeper.method_5803(false);
            level.method_53875((class_1297)creeper);
            this.fakeCreepers.add(new FakeCreeper(creeper, playerPos.field_1352, playerPos.field_1351, playerPos.field_1350));
        }
        this.playCreeperSound(level, playerPos);
    }

    private void playCreeperSound(class_638 level, class_243 pos) {
        level.method_8486(pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_15057, class_3419.field_15251, 2.0f, 1.0f, false);
    }

    private void updateFakeCreepers(class_638 level, class_746 player) {
        class_243 playerPos = player.method_19538();
        for (FakeCreeper fakeCreeper : this.fakeCreepers) {
            class_1548 creeper = fakeCreeper.creeper();
            if (!creeper.method_5805()) continue;
            class_243 creeperPos = creeper.method_19538();
            class_243 direction = playerPos.method_1020(creeperPos).method_1029().method_1021(0.065);
            class_243 newPos = creeperPos.method_1019(direction);
            creeper.method_5814(newPos.field_1352, newPos.field_1351, newPos.field_1350);
            creeper.method_5773();
            float yaw = (float)(Math.atan2(playerPos.field_1350 - newPos.field_1350, playerPos.field_1352 - newPos.field_1352) * 180.0 / Math.PI) - 90.0f;
            creeper.method_36456(yaw);
            creeper.method_5847(yaw);
        }
    }

    private void explodeFakeCreepers(class_638 level) {
        for (FakeCreeper fakeCreeper : this.fakeCreepers) {
            class_1548 creeper = fakeCreeper.creeper();
            if (!creeper.method_5805()) continue;
            class_243 pos = creeper.method_19538();
            for (int i = 0; i < 30; ++i) {
                double offsetX = (level.field_9229.method_43058() - 0.5) * 3.0;
                double offsetY = level.field_9229.method_43058() * 3.0;
                double offsetZ = (level.field_9229.method_43058() - 0.5) * 3.0;
                level.method_8406((class_2394)class_2398.field_11236, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 0.0, 0.0, 0.0);
                level.method_8406((class_2394)class_2398.field_11237, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, offsetX * 0.1, offsetY * 0.1, offsetZ * 0.1);
            }
            level.method_8486(pos.field_1352, pos.field_1351, pos.field_1350, (class_3414)class_3417.field_15152.comp_349(), class_3419.field_15251, 2.0f, 1.0f, false);
            creeper.method_31472();
        }
    }

    private void removeFakeCreepers(class_638 level) {
        for (FakeCreeper fakeCreeper : this.fakeCreepers) {
            class_1548 creeper = fakeCreeper.creeper();
            if (!creeper.method_5805()) continue;
            creeper.method_31472();
        }
    }

    private record FakeCreeper(class_1548 creeper, double startX, double startY, double startZ) {
    }
}

