/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect.cookie.client;

import de.markusbordihn.cookiescandyandcakes.effect.ClientEffectInterface;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1550;
import net.minecraft.class_1577;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class ElderGuardianCookieMysticEffectClient
implements ClientEffectInterface {
    private static final int SPAWN_TICK = 20;
    private static final int GAZE_DURATION = 200;
    private static final int DISSOLVE_TICK = 220;
    private static final int TOTAL_DURATION = 260;
    private static final int GUARDIAN_SPAWN_TICK = 60;
    private final List<class_1577> guardians = new ArrayList<class_1577>();
    private class_1550 elderGuardian;
    private class_243 elderGuardianBasePos;
    private int breathingTick = 0;

    @Override
    public int getDuration() {
        return 260;
    }

    @Override
    public void tick(class_746 localPlayer, int elapsedTicks) {
        class_1937 class_19372 = localPlayer.method_37908();
        if (!(class_19372 instanceof class_638)) {
            return;
        }
        class_638 clientLevel = (class_638)class_19372;
        if (elapsedTicks == 20) {
            this.spawnElderGuardian(clientLevel, localPlayer);
        } else if (elapsedTicks == 60) {
            this.spawnSideGuardians(clientLevel, localPlayer);
        } else if (elapsedTicks > 20 && elapsedTicks < 220) {
            this.updateElderGuardian(localPlayer);
            ++this.breathingTick;
        } else if (elapsedTicks == 220) {
            this.dissolveElderGuardian(clientLevel);
            this.dissolveGuardians(clientLevel);
        }
    }

    @Override
    public void onStart(class_746 localPlayer) {
        this.elderGuardian = null;
        this.guardians.clear();
        this.elderGuardianBasePos = null;
        this.breathingTick = 0;
    }

    @Override
    public void onEnd(class_746 localPlayer) {
        if (this.elderGuardian != null && this.elderGuardian.method_5805()) {
            this.elderGuardian.method_31472();
        }
        this.elderGuardian = null;
        for (class_1577 guardian : this.guardians) {
            if (guardian == null || !guardian.method_5805()) continue;
            guardian.method_31472();
        }
        this.guardians.clear();
    }

    private void spawnElderGuardian(class_638 level, class_746 player) {
        class_243 lookDirection = player.method_5720();
        this.elderGuardianBasePos = player.method_19538().method_1019(lookDirection.method_1021(3.0)).method_1031(0.0, 1.0, 0.0);
        this.elderGuardian = (class_1550)class_1299.field_6086.method_5883((class_1937)level);
        if (this.elderGuardian != null) {
            this.elderGuardian.method_5814(this.elderGuardianBasePos.field_1352, this.elderGuardianBasePos.field_1351, this.elderGuardianBasePos.field_1350);
            this.elderGuardian.method_5875(true);
            this.elderGuardian.method_5684(true);
            this.elderGuardian.method_5803(true);
            float yaw = (float)Math.toDegrees(Math.atan2(-lookDirection.field_1352, lookDirection.field_1350));
            this.elderGuardian.method_36456(yaw);
            this.elderGuardian.field_5982 = yaw;
            this.elderGuardian.method_5847(yaw);
            level.method_53875((class_1297)this.elderGuardian);
            level.method_8486(this.elderGuardianBasePos.field_1352, this.elderGuardianBasePos.field_1351, this.elderGuardianBasePos.field_1350, class_3417.field_15203, class_3419.field_15251, 1.0f, 1.0f, false);
            this.spawnWaterParticles(level, this.elderGuardianBasePos);
        }
    }

    private void spawnSideGuardians(class_638 level, class_746 player) {
        class_1577 rightGuardian;
        if (this.elderGuardianBasePos == null) {
            return;
        }
        class_243 lookDirection = player.method_5720();
        class_243 rightDirection = new class_243(-lookDirection.field_1350, 0.0, lookDirection.field_1352).method_1029();
        class_1577 leftGuardian = (class_1577)class_1299.field_6118.method_5883((class_1937)level);
        if (leftGuardian != null) {
            class_243 leftPos = this.elderGuardianBasePos.method_1019(rightDirection.method_1021(-4.0)).method_1031(0.0, 0.5, 0.0);
            leftGuardian.method_5814(leftPos.field_1352, leftPos.field_1351, leftPos.field_1350);
            leftGuardian.method_5875(true);
            leftGuardian.method_5684(true);
            leftGuardian.method_5803(true);
            level.method_53875((class_1297)leftGuardian);
            this.guardians.add(leftGuardian);
            this.spawnWaterParticles(level, leftPos);
        }
        if ((rightGuardian = (class_1577)class_1299.field_6118.method_5883((class_1937)level)) != null) {
            class_243 rightPos = this.elderGuardianBasePos.method_1019(rightDirection.method_1021(4.0)).method_1031(0.0, 0.5, 0.0);
            rightGuardian.method_5814(rightPos.field_1352, rightPos.field_1351, rightPos.field_1350);
            rightGuardian.method_5875(true);
            rightGuardian.method_5684(true);
            rightGuardian.method_5803(true);
            level.method_53875((class_1297)rightGuardian);
            this.guardians.add(rightGuardian);
            this.spawnWaterParticles(level, rightPos);
        }
        level.method_8486(this.elderGuardianBasePos.field_1352, this.elderGuardianBasePos.field_1351, this.elderGuardianBasePos.field_1350, class_3417.field_14714, class_3419.field_15251, 1.0f, 0.9f, false);
    }

    private void updateElderGuardian(class_746 player) {
        float yaw;
        class_243 direction;
        class_243 playerPos;
        if (this.elderGuardian != null && this.elderGuardian.method_5805() && this.elderGuardianBasePos != null) {
            double breathingOffset = Math.sin((double)this.breathingTick * 0.05) * 0.15;
            class_243 newPos = this.elderGuardianBasePos.method_1031(0.0, breathingOffset, 0.0);
            this.elderGuardian.method_5814(newPos.field_1352, newPos.field_1351, newPos.field_1350);
            playerPos = player.method_33571();
            direction = playerPos.method_1020(newPos).method_1029();
            yaw = (float)Math.toDegrees(Math.atan2(-direction.field_1352, direction.field_1350));
            this.elderGuardian.method_36456(yaw);
            this.elderGuardian.method_5847(yaw);
            class_1937 class_19372 = player.method_37908();
            if (class_19372 instanceof class_638) {
                class_638 clientLevel = (class_638)class_19372;
                if (player.field_6012 % 10 == 0) {
                    this.spawnBubbleParticles(clientLevel, newPos);
                }
            }
        }
        for (class_1577 guardian : this.guardians) {
            if (guardian == null || !guardian.method_5805()) continue;
            class_243 guardianPos = guardian.method_19538();
            playerPos = player.method_33571();
            direction = playerPos.method_1020(guardianPos).method_1029();
            yaw = (float)Math.toDegrees(Math.atan2(-direction.field_1352, direction.field_1350));
            guardian.method_36456(yaw);
            guardian.method_5847(yaw);
        }
    }

    private void dissolveElderGuardian(class_638 level) {
        if (this.elderGuardian != null && this.elderGuardian.method_5805()) {
            class_243 pos = this.elderGuardian.method_19538();
            for (int i = 0; i < 30; ++i) {
                double offsetX = (level.field_9229.method_43058() - 0.5) * 2.0;
                double offsetY = level.field_9229.method_43058() * 2.0;
                double offsetZ = (level.field_9229.method_43058() - 0.5) * 2.0;
                level.method_8406((class_2394)class_2398.field_11238, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 0.0, 0.1, 0.0);
                level.method_8406((class_2394)class_2398.field_11207, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, (level.field_9229.method_43058() - 0.5) * 0.1, level.field_9229.method_43058() * 0.1, (level.field_9229.method_43058() - 0.5) * 0.1);
            }
            level.method_8486(pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_15161, class_3419.field_15251, 1.0f, 1.2f, false);
            this.elderGuardian.method_31472();
        }
    }

    private void dissolveGuardians(class_638 level) {
        for (class_1577 guardian : this.guardians) {
            if (guardian == null || !guardian.method_5805()) continue;
            class_243 pos = guardian.method_19538();
            for (int i = 0; i < 20; ++i) {
                double offsetX = (level.field_9229.method_43058() - 0.5) * 1.5;
                double offsetY = level.field_9229.method_43058() * 1.5;
                double offsetZ = (level.field_9229.method_43058() - 0.5) * 1.5;
                level.method_8406((class_2394)class_2398.field_11238, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 0.0, 0.05, 0.0);
            }
            guardian.method_31472();
        }
    }

    private void spawnWaterParticles(class_638 level, class_243 pos) {
        for (int i = 0; i < 20; ++i) {
            double offsetX = (level.field_9229.method_43058() - 0.5) * 1.5;
            double offsetY = level.field_9229.method_43058() * 1.5;
            double offsetZ = (level.field_9229.method_43058() - 0.5) * 1.5;
            level.method_8406((class_2394)class_2398.field_11238, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 0.0, 0.05, 0.0);
        }
    }

    private void spawnBubbleParticles(class_638 level, class_243 pos) {
        for (int i = 0; i < 3; ++i) {
            double offsetX = level.field_9229.method_43058() - 0.5;
            double offsetY = level.field_9229.method_43058();
            double offsetZ = level.field_9229.method_43058() - 0.5;
            level.method_8406((class_2394)class_2398.field_11247, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 0.0, 0.02, 0.0);
        }
    }
}

