/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect.cookie;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.effect.ClientEffectInterface;
import de.markusbordihn.cookiescandyandcakes.effect.ClientEffectManager;
import de.markusbordihn.cookiescandyandcakes.effect.cookie.client.CreeperCrunchCookieCursedEffectClient;
import de.markusbordihn.cookiescandyandcakes.effect.cookie.client.CreeperCrunchCookieMysticEffectClient;
import de.markusbordihn.cookiescandyandcakes.effect.cookie.client.ElderGuardianCookieCursedEffectClient;
import de.markusbordihn.cookiescandyandcakes.effect.cookie.client.ElderGuardianCookieMysticEffectClient;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.player.LocalPlayer;

public class CookieClientEffectManager
extends ClientEffectManager {
    private static final Map<CookieType, ClientEffectInterface> COOKIE_EFFECTS = new HashMap<CookieType, ClientEffectInterface>();
    private static final CookieClientEffectManager INSTANCE = new CookieClientEffectManager();

    private CookieClientEffectManager() {
    }

    public static CookieClientEffectManager getInstance() {
        return INSTANCE;
    }

    public static void applyCookieEffect(LocalPlayer player, CookieType cookieType) {
        if (player == null || cookieType == null) {
            return;
        }
        ClientEffectInterface effect = COOKIE_EFFECTS.get((Object)cookieType);
        if (effect != null) {
            CookieClientEffectManager.getInstance().applyEffect(player, effect);
        }
    }

    public static void tickPlayer(LocalPlayer player) {
        CookieClientEffectManager.getInstance().tick(player);
    }

    public static void removeCookieEffect(LocalPlayer player) {
        CookieClientEffectManager.getInstance().removeEffect(player);
    }

    public static void clearAllEffects() {
        CookieClientEffectManager.getInstance().clearAll();
    }

    public static boolean hasCookieEffect(LocalPlayer player) {
        return CookieClientEffectManager.getInstance().hasActiveEffect(player);
    }

    static {
        COOKIE_EFFECTS.put(CookieType.CREEPER_CRUNCH_COOKIE_MYSTIC, new CreeperCrunchCookieMysticEffectClient());
        COOKIE_EFFECTS.put(CookieType.CREEPER_CRUNCH_COOKIE_CURSED, new CreeperCrunchCookieCursedEffectClient());
        COOKIE_EFFECTS.put(CookieType.ELDER_GUARDIAN_COOKIE_MYSTIC, new ElderGuardianCookieMysticEffectClient());
        COOKIE_EFFECTS.put(CookieType.ELDER_GUARDIAN_COOKIE_CURSED, new ElderGuardianCookieCursedEffectClient());
    }
}

