/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item.variants;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieSoundType;
import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.effect.cookie.CookieClientEffectManager;
import de.markusbordihn.cookiescandyandcakes.effect.cookie.CookieServerEffectManager;
import de.markusbordihn.cookiescandyandcakes.item.base.BaseSpecialCookie;
import de.markusbordihn.cookiescandyandcakes.item.base.IdentifiableCookie;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class MysticCookie
extends BaseSpecialCookie
implements IdentifiableCookie {
    public MysticCookie(CookieType cookieType) {
        super(cookieType);
    }

    @Override
    public CookieType getCookieType() {
        return this.cookieType;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        this.onConsume(livingEntity);
        if (!level.isClientSide) {
            this.spawnParticles(level, livingEntity);
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                CookieServerEffectManager.applyCookieEffect(serverPlayer, this.cookieType);
            }
        } else if (livingEntity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)livingEntity;
            CookieClientEffectManager.applyCookieEffect(localPlayer, this.cookieType);
        }
        if (!level.isClientSide) {
            SoundEvent sound;
            LightningBolt lightning;
            CookieType.SpecialCookieEffect effect = this.cookieType.getSpecialCookieEffect();
            if (!effect.hasEffects()) {
                return super.finishUsingItem(stack, level, livingEntity);
            }
            if (level.random.nextFloat() < effect.lightningChance() && (lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level)) != null) {
                lightning.moveTo(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
                lightning.setVisualOnly(true);
                level.addFreshEntity((Entity)lightning);
            }
            if (effect.enableSounds() && (sound = CookieSoundType.getMysticSound(effect.mysticSoundType())) != null) {
                level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), sound, SoundSource.PLAYERS, effect.soundVolume(), CookieSoundType.getPitch(effect.mysticSoundType(), level.random.nextFloat()));
            }
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add(this.getIdentifiedTooltip());
    }

    public Component getName(ItemStack stack) {
        return this.getUnidentifiedName();
    }
}

