/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item.variants;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieSoundType;
import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.item.base.BaseSpecialCookie;
import de.markusbordihn.cookiescandyandcakes.item.base.IdentifiableCookie;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CursedCookie
extends BaseSpecialCookie
implements IdentifiableCookie {
    public CursedCookie(CookieType cookieType) {
        super(cookieType);
    }

    @Override
    public CookieType getCookieType() {
        return this.cookieType;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        this.onConsume(livingEntity);
        if (!level.isClientSide) {
            SoundEvent sound;
            LightningBolt lightning;
            this.spawnParticles(level, livingEntity);
            CookieType.SpecialCookieEffect effect = this.cookieType.getSpecialCookieEffect();
            if (!effect.hasEffects()) {
                return super.finishUsingItem(stack, level, livingEntity);
            }
            if (level.random.nextFloat() < effect.lightningChance() && (lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level)) != null) {
                lightning.moveTo(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
                lightning.setVisualOnly(true);
                level.addFreshEntity((Entity)lightning);
            }
            if (effect.enableSounds() && (sound = CookieSoundType.getCursedSound(effect.cursedSoundType())) != null) {
                level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), sound, SoundSource.PLAYERS, effect.soundVolume(), CookieSoundType.getPitch(effect.cursedSoundType(), level.random.nextFloat()));
            }
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (effect.darknessEffectDuration() > 0) {
                    player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, effect.darknessEffectDuration(), 0, false, false, false));
                }
            }
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add(this.getIdentifiedTooltip());
    }

    public Component getName(ItemStack stack) {
        return this.getUnidentifiedName();
    }
}

