/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper;

import com.google.gson.TypeAdapter;
import com.mojang.brigadier.CommandDispatcher;
import dev.xpple.betterconfig.api.ModConfigBuilder;
import dev.xpple.seedmapper.command.arguments.MapFeatureArgument;
import dev.xpple.seedmapper.command.arguments.SeedResolutionArgument;
import dev.xpple.seedmapper.command.commands.BuildInfoCommand;
import dev.xpple.seedmapper.command.commands.CheckSeedCommand;
import dev.xpple.seedmapper.command.commands.ClearCommand;
import dev.xpple.seedmapper.command.commands.DiscordCommand;
import dev.xpple.seedmapper.command.commands.HighlightCommand;
import dev.xpple.seedmapper.command.commands.LocateCommand;
import dev.xpple.seedmapper.command.commands.SeedMapCommand;
import dev.xpple.seedmapper.command.commands.SourceCommand;
import dev.xpple.seedmapper.command.commands.StopTaskCommand;
import dev.xpple.seedmapper.config.Configs;
import dev.xpple.seedmapper.config.MapFeatureAdapter;
import dev.xpple.seedmapper.config.SeedResolutionAdapter;
import dev.xpple.seedmapper.render.RenderManager;
import dev.xpple.seedmapper.seedmap.MapFeature;
import dev.xpple.seedmapper.util.SeedDatabaseHelper;
import dev.xpple.simplewaypoints.api.SimpleWaypointsAPI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_304;
import net.minecraft.class_7157;

public class SeedMapper
implements ClientModInitializer {
    public static final String MOD_ID = "seedmapper";
    public static final Path modConfigPath;

    public void onInitializeClient() {
        new ModConfigBuilder(MOD_ID, Configs.class).registerType(SeedResolutionArgument.SeedResolution.class, (TypeAdapter)new SeedResolutionAdapter(), SeedResolutionArgument::seedResolution).registerType(MapFeature.class, (TypeAdapter)new MapFeatureAdapter(), MapFeatureArgument::mapFeature).registerGlobalChangeHook(event -> {
            if (event.config().equals("DevMode")) {
                try {
                    ClientCommandManager.refreshCommandCompletions();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }).build();
        SimpleWaypointsAPI.getInstance().registerCommandAlias("sm:waypoint");
        SeedDatabaseHelper.fetchSeeds();
        class_304 keyMapping = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.seedMap", 77, class_304.class_11900.field_62558));
        ClientTickEvents.END_CLIENT_TICK.register(minecraft -> {
            while (keyMapping.method_1436()) {
                minecraft.field_1724.field_3944.method_45730("sm:seedmap");
            }
        });
        ClientCommandRegistrationCallback.EVENT.register(SeedMapper::registerCommands);
        RenderManager.registerEvents();
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 context) {
        LocateCommand.register(dispatcher);
        SourceCommand.register(dispatcher);
        CheckSeedCommand.register(dispatcher);
        BuildInfoCommand.register(dispatcher);
        HighlightCommand.register(dispatcher);
        ClearCommand.register(dispatcher);
        StopTaskCommand.register(dispatcher);
        SeedMapCommand.register(dispatcher);
        DiscordCommand.register(dispatcher);
    }

    static {
        Path tempFile;
        modConfigPath = FabricLoader.getInstance().getConfigDir().resolve(MOD_ID);
        String libraryName = System.mapLibraryName("cubiomes");
        ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow();
        try {
            tempFile = Files.createTempFile(libraryName, "", new FileAttribute[0]);
            Files.copy((Path)modContainer.findPath(libraryName).orElseThrow(), tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.load(tempFile.toAbsolutePath().toString());
    }
}

