/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.command.arguments;

import com.github.cubiomes.Cubiomes;
import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.seedmapper.command.CommandExceptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;

public class CaveCarverArgument
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("cave", "nether_cave");
    private static final Map<String, Integer> CAVE_CARVERS = ImmutableMap.builder().put((Object)"cave", (Object)Cubiomes.CAVE_CARVER()).put((Object)"cave_extra_underground", (Object)Cubiomes.CAVE_EXTRA_UNDERGROUND_CARVER()).put((Object)"ocean_cave", (Object)Cubiomes.OCEAN_CAVE_CARVER()).put((Object)"underwater_cave", (Object)Cubiomes.UNDERWATER_CAVE_CARVER()).put((Object)"nether_cave", (Object)Cubiomes.NETHER_CAVE_CARVER()).build();

    public static CaveCarverArgument caveCarver() {
        return new CaveCarverArgument();
    }

    public static int getCaveCarver(CommandContext<FabricClientCommandSource> context, String name) {
        return (Integer)context.getArgument(name, Integer.class);
    }

    public Integer parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String caveCarverString = reader.readUnquotedString();
        Integer caveCarver = CAVE_CARVERS.get(caveCarverString);
        if (caveCarver == null) {
            reader.setCursor(cursor);
            throw CommandExceptions.UNKNOWN_CAVE_CARVER_EXCEPTION.create((Object)caveCarverString);
        }
        return caveCarver;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(CAVE_CARVERS.keySet(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

