/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.command.arguments;

import com.github.cubiomes.Cubiomes;
import com.github.cubiomes.EnchantInstance;
import com.github.cubiomes.ItemStack;
import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.seedmapper.command.CommandExceptions;
import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5321;

public class ItemAndEnchantmentsPredicateArgument
implements ArgumentType<EnchantedItem> {
    private static final Collection<String> EXAMPLES = Arrays.asList("apple", "diamond_pickaxe", "tnt");
    private static final SimpleCommandExceptionType EXPECTED_WITH_WITHOUT_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.exceptions.expectedWithWithout"));
    private static final Map<String, Integer> ITEMS = ImmutableMap.builder().put((Object)"ancient_debris", (Object)Cubiomes.ITEM_ANCIENT_DEBRIS()).put((Object)"apple", (Object)Cubiomes.ITEM_APPLE()).put((Object)"arrow", (Object)Cubiomes.ITEM_ARROW()).put((Object)"bamboo", (Object)Cubiomes.ITEM_BAMBOO()).put((Object)"beetroot_seeds", (Object)Cubiomes.ITEM_BEETROOT_SEEDS()).put((Object)"bell", (Object)Cubiomes.ITEM_BELL()).put((Object)"bone", (Object)Cubiomes.ITEM_BONE()).put((Object)"bone_block", (Object)Cubiomes.ITEM_BONE_BLOCK()).put((Object)"book", (Object)Cubiomes.ITEM_BOOK()).put((Object)"carrot", (Object)Cubiomes.ITEM_CARROT()).put((Object)"chain", (Object)Cubiomes.ITEM_CHAIN()).put((Object)"clock", (Object)Cubiomes.ITEM_CLOCK()).put((Object)"coal", (Object)Cubiomes.ITEM_COAL()).put((Object)"coast_armor_trim_smithing_template", (Object)Cubiomes.ITEM_COAST_ARMOR_TRIM_SMITHING_TEMPLATE()).put((Object)"compass", (Object)Cubiomes.ITEM_COMPASS()).put((Object)"cooked_cod", (Object)Cubiomes.ITEM_COOKED_COD()).put((Object)"cooked_porkchop", (Object)Cubiomes.ITEM_COOKED_PORKCHOP()).put((Object)"cooked_salmon", (Object)Cubiomes.ITEM_COOKED_SALMON()).put((Object)"copper_horse_armor", (Object)Cubiomes.ITEM_COPPER_HORSE_ARMOR()).put((Object)"crossbow", (Object)Cubiomes.ITEM_CROSSBOW()).put((Object)"crying_obsidian", (Object)Cubiomes.ITEM_CRYING_OBSIDIAN()).put((Object)"dark_oak_log", (Object)Cubiomes.ITEM_DARK_OAK_LOG()).put((Object)"diamond", (Object)Cubiomes.ITEM_DIAMOND()).put((Object)"diamond_boots", (Object)Cubiomes.ITEM_DIAMOND_BOOTS()).put((Object)"diamond_chestplate", (Object)Cubiomes.ITEM_DIAMOND_CHESTPLATE()).put((Object)"diamond_helmet", (Object)Cubiomes.ITEM_DIAMOND_HELMET()).put((Object)"diamond_horse_armor", (Object)Cubiomes.ITEM_DIAMOND_HORSE_ARMOR()).put((Object)"diamond_leggings", (Object)Cubiomes.ITEM_DIAMOND_LEGGINGS()).put((Object)"diamond_pickaxe", (Object)Cubiomes.ITEM_DIAMOND_PICKAXE()).put((Object)"diamond_shovel", (Object)Cubiomes.ITEM_DIAMOND_SHOVEL()).put((Object)"diamond_sword", (Object)Cubiomes.ITEM_DIAMOND_SWORD()).put((Object)"dune_armor_trim_smithing_template", (Object)Cubiomes.ITEM_DUNE_ARMOR_TRIM_SMITHING_TEMPLATE()).put((Object)"emerald", (Object)Cubiomes.ITEM_EMERALD()).put((Object)"enchanted_golden_apple", (Object)Cubiomes.ITEM_ENCHANTED_GOLDEN_APPLE()).put((Object)"experience_bottle", (Object)Cubiomes.ITEM_EXPERIENCE_BOTTLE()).put((Object)"feather", (Object)Cubiomes.ITEM_FEATHER()).put((Object)"fire_charge", (Object)Cubiomes.ITEM_FIRE_CHARGE()).put((Object)"flint", (Object)Cubiomes.ITEM_FLINT()).put((Object)"flint_and_steel", (Object)Cubiomes.ITEM_FLINT_AND_STEEL()).put((Object)"gilded_blackstone", (Object)Cubiomes.ITEM_GILDED_BLACKSTONE()).put((Object)"glistering_melon_slice", (Object)Cubiomes.ITEM_GLISTERING_MELON_SLICE()).put((Object)"goat_horn", (Object)Cubiomes.ITEM_GOAT_HORN()).put((Object)"golden_apple", (Object)Cubiomes.ITEM_GOLDEN_APPLE()).put((Object)"golden_axe", (Object)Cubiomes.ITEM_GOLDEN_AXE()).put((Object)"golden_boots", (Object)Cubiomes.ITEM_GOLDEN_BOOTS()).put((Object)"golden_carrot", (Object)Cubiomes.ITEM_GOLDEN_CARROT()).put((Object)"golden_chestplate", (Object)Cubiomes.ITEM_GOLDEN_CHESTPLATE()).put((Object)"golden_helmet", (Object)Cubiomes.ITEM_GOLDEN_HELMET()).put((Object)"golden_hoe", (Object)Cubiomes.ITEM_GOLDEN_HOE()).put((Object)"golden_horse_armor", (Object)Cubiomes.ITEM_GOLDEN_HORSE_ARMOR()).put((Object)"golden_leggings", (Object)Cubiomes.ITEM_GOLDEN_LEGGINGS()).put((Object)"golden_pickaxe", (Object)Cubiomes.ITEM_GOLDEN_PICKAXE()).put((Object)"golden_shovel", (Object)Cubiomes.ITEM_GOLDEN_SHOVEL()).put((Object)"golden_sword", (Object)Cubiomes.ITEM_GOLDEN_SWORD()).put((Object)"gold_block", (Object)Cubiomes.ITEM_GOLD_BLOCK()).put((Object)"gold_ingot", (Object)Cubiomes.ITEM_GOLD_INGOT()).put((Object)"gold_nugget", (Object)Cubiomes.ITEM_GOLD_NUGGET()).put((Object)"gunpowder", (Object)Cubiomes.ITEM_GUNPOWDER()).put((Object)"heart_of_the_sea", (Object)Cubiomes.ITEM_HEART_OF_THE_SEA()).put((Object)"iron_block", (Object)Cubiomes.ITEM_IRON_BLOCK()).put((Object)"iron_boots", (Object)Cubiomes.ITEM_IRON_BOOTS()).put((Object)"iron_chain", (Object)Cubiomes.ITEM_IRON_CHAIN()).put((Object)"iron_chestplate", (Object)Cubiomes.ITEM_IRON_CHESTPLATE()).put((Object)"iron_helmet", (Object)Cubiomes.ITEM_IRON_HELMET()).put((Object)"iron_horse_armor", (Object)Cubiomes.ITEM_IRON_HORSE_ARMOR()).put((Object)"iron_ingot", (Object)Cubiomes.ITEM_IRON_INGOT()).put((Object)"iron_leggings", (Object)Cubiomes.ITEM_IRON_LEGGINGS()).put((Object)"iron_nugget", (Object)Cubiomes.ITEM_IRON_NUGGET()).put((Object)"iron_pickaxe", (Object)Cubiomes.ITEM_IRON_PICKAXE()).put((Object)"iron_shovel", (Object)Cubiomes.ITEM_IRON_SHOVEL()).put((Object)"iron_sword", (Object)Cubiomes.ITEM_IRON_SWORD()).put((Object)"lapis_lazuli", (Object)Cubiomes.ITEM_LAPIS_LAZULI()).put((Object)"leather", (Object)Cubiomes.ITEM_LEATHER()).put((Object)"leather_boots", (Object)Cubiomes.ITEM_LEATHER_BOOTS()).put((Object)"leather_chestplate", (Object)Cubiomes.ITEM_LEATHER_CHESTPLATE()).put((Object)"leather_helmet", (Object)Cubiomes.ITEM_LEATHER_HELMET()).put((Object)"leather_leggings", (Object)Cubiomes.ITEM_LEATHER_LEGGINGS()).put((Object)"light_weighted_pressure_plate", (Object)Cubiomes.ITEM_LIGHT_WEIGHTED_PRESSURE_PLATE()).put((Object)"lodestone", (Object)Cubiomes.ITEM_LODESTONE()).put((Object)"magma_cream", (Object)Cubiomes.ITEM_MAGMA_CREAM()).put((Object)"map", (Object)Cubiomes.ITEM_MAP()).put((Object)"moss_block", (Object)Cubiomes.ITEM_MOSS_BLOCK()).put((Object)"music_disc_pigstep", (Object)Cubiomes.ITEM_MUSIC_DISC_PIGSTEP()).put((Object)"netherite_scrap", (Object)Cubiomes.ITEM_NETHERITE_SCRAP()).put((Object)"netherite_upgrade_smithing_template", (Object)Cubiomes.ITEM_NETHERITE_UPGRADE_SMITHING_TEMPLATE()).put((Object)"nether_wart", (Object)Cubiomes.ITEM_NETHER_WART()).put((Object)"obsidian", (Object)Cubiomes.ITEM_OBSIDIAN()).put((Object)"paper", (Object)Cubiomes.ITEM_PAPER()).put((Object)"piglin_banner_pattern", (Object)Cubiomes.ITEM_PIGLIN_BANNER_PATTERN()).put((Object)"poisonous_potato", (Object)Cubiomes.ITEM_POISONOUS_POTATO()).put((Object)"potion", (Object)Cubiomes.ITEM_POTION()).put((Object)"potato", (Object)Cubiomes.ITEM_POTATO()).put((Object)"prismarine_crystals", (Object)Cubiomes.ITEM_PRISMARINE_CRYSTALS()).put((Object)"pumpkin", (Object)Cubiomes.ITEM_PUMPKIN()).put((Object)"rib_armor_trim_smithing_template", (Object)Cubiomes.ITEM_RIB_ARMOR_TRIM_SMITHING_TEMPLATE()).put((Object)"rotten_flesh", (Object)Cubiomes.ITEM_ROTTEN_FLESH()).put((Object)"saddle", (Object)Cubiomes.ITEM_SADDLE()).put((Object)"sand", (Object)Cubiomes.ITEM_SAND()).put((Object)"sentry_armor_trim_smithing_template", (Object)Cubiomes.ITEM_SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE()).put((Object)"snout_armor_trim_smithing_template", (Object)Cubiomes.ITEM_SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE()).put((Object)"spectral_arrow", (Object)Cubiomes.ITEM_SPECTRAL_ARROW()).put((Object)"spider_eye", (Object)Cubiomes.ITEM_SPIDER_EYE()).put((Object)"spire_armor_trim_smithing_template", (Object)Cubiomes.ITEM_SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE()).put((Object)"stone_axe", (Object)Cubiomes.ITEM_STONE_AXE()).put((Object)"string", (Object)Cubiomes.ITEM_STRING()).put((Object)"suspicious_stew", (Object)Cubiomes.ITEM_SUSPICIOUS_STEW()).put((Object)"tnt", (Object)Cubiomes.ITEM_TNT()).put((Object)"tripwire_hook", (Object)Cubiomes.ITEM_TRIPWIRE_HOOK()).put((Object)"wheat", (Object)Cubiomes.ITEM_WHEAT()).put((Object)"wild_armor_trim_smithing_template", (Object)Cubiomes.ITEM_WILD_ARMOR_TRIM_SMITHING_TEMPLATE()).build();
    public static final Map<Integer, class_1792> ITEM_ID_TO_MC = ImmutableMap.builder().put((Object)Cubiomes.ITEM_ANCIENT_DEBRIS(), (Object)class_1802.field_22019).put((Object)Cubiomes.ITEM_APPLE(), (Object)class_1802.field_8279).put((Object)Cubiomes.ITEM_ARROW(), (Object)class_1802.field_8107).put((Object)Cubiomes.ITEM_BAMBOO(), (Object)class_1802.field_8648).put((Object)Cubiomes.ITEM_BEETROOT_SEEDS(), (Object)class_1802.field_8309).put((Object)Cubiomes.ITEM_BELL(), (Object)class_1802.field_16315).put((Object)Cubiomes.ITEM_BONE(), (Object)class_1802.field_8606).put((Object)Cubiomes.ITEM_BONE_BLOCK(), (Object)class_1802.field_8242).put((Object)Cubiomes.ITEM_BOOK(), (Object)class_1802.field_8529).put((Object)Cubiomes.ITEM_CARROT(), (Object)class_1802.field_8179).put((Object)Cubiomes.ITEM_CHAIN(), (Object)class_1802.field_23983).put((Object)Cubiomes.ITEM_CLOCK(), (Object)class_1802.field_8557).put((Object)Cubiomes.ITEM_COAL(), (Object)class_1802.field_8713).put((Object)Cubiomes.ITEM_COAST_ARMOR_TRIM_SMITHING_TEMPLATE(), (Object)class_1802.field_41949).put((Object)Cubiomes.ITEM_COMPASS(), (Object)class_1802.field_8251).put((Object)Cubiomes.ITEM_COOKED_COD(), (Object)class_1802.field_8373).put((Object)Cubiomes.ITEM_COOKED_PORKCHOP(), (Object)class_1802.field_8261).put((Object)Cubiomes.ITEM_COOKED_SALMON(), (Object)class_1802.field_8509).put((Object)Cubiomes.ITEM_COPPER_HORSE_ARMOR(), (Object)class_1802.field_61348).put((Object)Cubiomes.ITEM_CROSSBOW(), (Object)class_1802.field_8399).put((Object)Cubiomes.ITEM_CRYING_OBSIDIAN(), (Object)class_1802.field_22421).put((Object)Cubiomes.ITEM_DARK_OAK_LOG(), (Object)class_1802.field_8652).put((Object)Cubiomes.ITEM_DIAMOND(), (Object)class_1802.field_8477).put((Object)Cubiomes.ITEM_DIAMOND_BOOTS(), (Object)class_1802.field_8285).put((Object)Cubiomes.ITEM_DIAMOND_CHESTPLATE(), (Object)class_1802.field_8058).put((Object)Cubiomes.ITEM_DIAMOND_HELMET(), (Object)class_1802.field_8805).put((Object)Cubiomes.ITEM_DIAMOND_HORSE_ARMOR(), (Object)class_1802.field_8807).put((Object)Cubiomes.ITEM_DIAMOND_LEGGINGS(), (Object)class_1802.field_8348).put((Object)Cubiomes.ITEM_DIAMOND_PICKAXE(), (Object)class_1802.field_8377).put((Object)Cubiomes.ITEM_DIAMOND_SHOVEL(), (Object)class_1802.field_8250).put((Object)Cubiomes.ITEM_DIAMOND_SWORD(), (Object)class_1802.field_8802).put((Object)Cubiomes.ITEM_DUNE_ARMOR_TRIM_SMITHING_TEMPLATE(), (Object)class_1802.field_41948).put((Object)Cubiomes.ITEM_EMERALD(), (Object)class_1802.field_8687).put((Object)Cubiomes.ITEM_ENCHANTED_GOLDEN_APPLE(), (Object)class_1802.field_8367).put((Object)Cubiomes.ITEM_EXPERIENCE_BOTTLE(), (Object)class_1802.field_8287).put((Object)Cubiomes.ITEM_FEATHER(), (Object)class_1802.field_8153).put((Object)Cubiomes.ITEM_FIRE_CHARGE(), (Object)class_1802.field_8814).put((Object)Cubiomes.ITEM_FLINT(), (Object)class_1802.field_8145).put((Object)Cubiomes.ITEM_FLINT_AND_STEEL(), (Object)class_1802.field_8884).put((Object)Cubiomes.ITEM_GILDED_BLACKSTONE(), (Object)class_1802.field_23847).put((Object)Cubiomes.ITEM_GLISTERING_MELON_SLICE(), (Object)class_1802.field_8597).put((Object)Cubiomes.ITEM_GOAT_HORN(), (Object)class_1802.field_39057).put((Object)Cubiomes.ITEM_GOLDEN_APPLE(), (Object)class_1802.field_8463).put((Object)Cubiomes.ITEM_GOLDEN_AXE(), (Object)class_1802.field_8825).put((Object)Cubiomes.ITEM_GOLDEN_BOOTS(), (Object)class_1802.field_8753).put((Object)Cubiomes.ITEM_GOLDEN_CARROT(), (Object)class_1802.field_8071).put((Object)Cubiomes.ITEM_GOLDEN_CHESTPLATE(), (Object)class_1802.field_8678).put((Object)Cubiomes.ITEM_GOLDEN_HELMET(), (Object)class_1802.field_8862).put((Object)Cubiomes.ITEM_GOLDEN_HOE(), (Object)class_1802.field_8303).put((Object)Cubiomes.ITEM_GOLDEN_HORSE_ARMOR(), (Object)class_1802.field_8560).put((Object)Cubiomes.ITEM_GOLDEN_LEGGINGS(), (Object)class_1802.field_8416).put((Object)Cubiomes.ITEM_GOLDEN_PICKAXE(), (Object)class_1802.field_8335).put((Object)Cubiomes.ITEM_GOLDEN_SHOVEL(), (Object)class_1802.field_8322).put((Object)Cubiomes.ITEM_GOLDEN_SWORD(), (Object)class_1802.field_8845).put((Object)Cubiomes.ITEM_GOLD_BLOCK(), (Object)class_1802.field_8494).put((Object)Cubiomes.ITEM_GOLD_INGOT(), (Object)class_1802.field_8695).put((Object)Cubiomes.ITEM_GOLD_NUGGET(), (Object)class_1802.field_8397).put((Object)Cubiomes.ITEM_GUNPOWDER(), (Object)class_1802.field_8054).put((Object)Cubiomes.ITEM_HEART_OF_THE_SEA(), (Object)class_1802.field_8207).put((Object)Cubiomes.ITEM_IRON_BLOCK(), (Object)class_1802.field_8773).put((Object)Cubiomes.ITEM_IRON_BOOTS(), (Object)class_1802.field_8660).put((Object)Cubiomes.ITEM_IRON_CHESTPLATE(), (Object)class_1802.field_8523).put((Object)Cubiomes.ITEM_IRON_HELMET(), (Object)class_1802.field_8743).put((Object)Cubiomes.ITEM_IRON_HORSE_ARMOR(), (Object)class_1802.field_8578).put((Object)Cubiomes.ITEM_IRON_INGOT(), (Object)class_1802.field_8620).put((Object)Cubiomes.ITEM_IRON_LEGGINGS(), (Object)class_1802.field_8396).put((Object)Cubiomes.ITEM_IRON_NUGGET(), (Object)class_1802.field_8675).put((Object)Cubiomes.ITEM_IRON_PICKAXE(), (Object)class_1802.field_8403).put((Object)Cubiomes.ITEM_IRON_SHOVEL(), (Object)class_1802.field_8699).put((Object)Cubiomes.ITEM_IRON_SWORD(), (Object)class_1802.field_8371).put((Object)Cubiomes.ITEM_LAPIS_LAZULI(), (Object)class_1802.field_8759).put((Object)Cubiomes.ITEM_LEATHER(), (Object)class_1802.field_8745).put((Object)Cubiomes.ITEM_LEATHER_BOOTS(), (Object)class_1802.field_8370).put((Object)Cubiomes.ITEM_LEATHER_CHESTPLATE(), (Object)class_1802.field_8577).put((Object)Cubiomes.ITEM_LEATHER_HELMET(), (Object)class_1802.field_8267).put((Object)Cubiomes.ITEM_LEATHER_LEGGINGS(), (Object)class_1802.field_8570).put((Object)Cubiomes.ITEM_LIGHT_WEIGHTED_PRESSURE_PLATE(), (Object)class_1802.field_8721).put((Object)Cubiomes.ITEM_LODESTONE(), (Object)class_1802.field_23256).put((Object)Cubiomes.ITEM_MAGMA_CREAM(), (Object)class_1802.field_8135).put((Object)Cubiomes.ITEM_MAP(), (Object)class_1802.field_8895).put((Object)Cubiomes.ITEM_MOSS_BLOCK(), (Object)class_1802.field_28654).put((Object)Cubiomes.ITEM_MUSIC_DISC_PIGSTEP(), (Object)class_1802.field_23984).put((Object)Cubiomes.ITEM_NETHERITE_SCRAP(), (Object)class_1802.field_22021).put((Object)Cubiomes.ITEM_NETHERITE_UPGRADE_SMITHING_TEMPLATE(), (Object)class_1802.field_41946).put((Object)Cubiomes.ITEM_NETHER_WART(), (Object)class_1802.field_8790).put((Object)Cubiomes.ITEM_OBSIDIAN(), (Object)class_1802.field_8281).put((Object)Cubiomes.ITEM_PAPER(), (Object)class_1802.field_8407).put((Object)Cubiomes.ITEM_PIGLIN_BANNER_PATTERN(), (Object)class_1802.field_23831).put((Object)Cubiomes.ITEM_POISONOUS_POTATO(), (Object)class_1802.field_8635).put((Object)Cubiomes.ITEM_POTION(), (Object)class_1802.field_8574).put((Object)Cubiomes.ITEM_POTATO(), (Object)class_1802.field_8567).put((Object)Cubiomes.ITEM_PRISMARINE_CRYSTALS(), (Object)class_1802.field_8434).put((Object)Cubiomes.ITEM_PUMPKIN(), (Object)class_1802.field_17518).put((Object)Cubiomes.ITEM_RIB_ARMOR_TRIM_SMITHING_TEMPLATE(), (Object)class_1802.field_41956).put((Object)Cubiomes.ITEM_ROTTEN_FLESH(), (Object)class_1802.field_8511).put((Object)Cubiomes.ITEM_SADDLE(), (Object)class_1802.field_8175).put((Object)Cubiomes.ITEM_SAND(), (Object)class_1802.field_8858).put((Object)Cubiomes.ITEM_SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE(), (Object)class_1802.field_41947).put((Object)Cubiomes.ITEM_SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE(), (Object)class_1802.field_41955).put((Object)Cubiomes.ITEM_SPECTRAL_ARROW(), (Object)class_1802.field_8236).put((Object)Cubiomes.ITEM_SPIDER_EYE(), (Object)class_1802.field_8680).put((Object)Cubiomes.ITEM_SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE(), (Object)class_1802.field_41957).put((Object)Cubiomes.ITEM_STONE_AXE(), (Object)class_1802.field_8062).put((Object)Cubiomes.ITEM_STRING(), (Object)class_1802.field_8276).put((Object)Cubiomes.ITEM_SUSPICIOUS_STEW(), (Object)class_1802.field_8766).put((Object)Cubiomes.ITEM_TNT(), (Object)class_1802.field_8626).put((Object)Cubiomes.ITEM_TRIPWIRE_HOOK(), (Object)class_1802.field_8366).put((Object)Cubiomes.ITEM_WHEAT(), (Object)class_1802.field_8861).put((Object)Cubiomes.ITEM_WILD_ARMOR_TRIM_SMITHING_TEMPLATE(), (Object)class_1802.field_41950).build();
    private static final Map<String, Integer> ENCHANTMENTS = ImmutableMap.builder().put((Object)"protection", (Object)Cubiomes.PROTECTION()).put((Object)"fire_protection", (Object)Cubiomes.FIRE_PROTECTION()).put((Object)"blast_protection", (Object)Cubiomes.BLAST_PROTECTION()).put((Object)"projectile_protection", (Object)Cubiomes.PROJECTILE_PROTECTION()).put((Object)"respiration", (Object)Cubiomes.RESPIRATION()).put((Object)"aqua_affinity", (Object)Cubiomes.AQUA_AFFINITY()).put((Object)"thorns", (Object)Cubiomes.THORNS()).put((Object)"swift_sneak", (Object)Cubiomes.SWIFT_SNEAK()).put((Object)"feather_falling", (Object)Cubiomes.FEATHER_FALLING()).put((Object)"depth_strider", (Object)Cubiomes.DEPTH_STRIDER()).put((Object)"frost_walker", (Object)Cubiomes.FROST_WALKER()).put((Object)"soul_speed", (Object)Cubiomes.SOUL_SPEED()).put((Object)"sharpness", (Object)Cubiomes.SHARPNESS()).put((Object)"smite", (Object)Cubiomes.SMITE()).put((Object)"bane_of_arthropods", (Object)Cubiomes.BANE_OF_ARTHROPODS()).put((Object)"knockback", (Object)Cubiomes.KNOCKBACK()).put((Object)"fire_aspect", (Object)Cubiomes.FIRE_ASPECT()).put((Object)"looting", (Object)Cubiomes.LOOTING()).put((Object)"sweeping_edge", (Object)Cubiomes.SWEEPING_EDGE()).put((Object)"efficiency", (Object)Cubiomes.EFFICIENCY()).put((Object)"silk_touch", (Object)Cubiomes.SILK_TOUCH()).put((Object)"fortune", (Object)Cubiomes.FORTUNE()).put((Object)"luck_of_the_sea", (Object)Cubiomes.LUCK_OF_THE_SEA()).put((Object)"lure", (Object)Cubiomes.LURE()).put((Object)"power", (Object)Cubiomes.POWER()).put((Object)"punch", (Object)Cubiomes.PUNCH()).put((Object)"flame", (Object)Cubiomes.FLAME()).put((Object)"infinity", (Object)Cubiomes.INFINITY_ENCHANTMENT()).put((Object)"quick_charge", (Object)Cubiomes.QUICK_CHARGE()).put((Object)"multishot", (Object)Cubiomes.MULTISHOT()).put((Object)"piercing", (Object)Cubiomes.PIERCING()).put((Object)"impaling", (Object)Cubiomes.IMPALING()).put((Object)"riptide", (Object)Cubiomes.RIPTIDE()).put((Object)"loyalty", (Object)Cubiomes.LOYALTY()).put((Object)"channeling", (Object)Cubiomes.CHANNELING()).put((Object)"density", (Object)Cubiomes.DENSITY()).put((Object)"breach", (Object)Cubiomes.BREACH()).put((Object)"wind_burst", (Object)Cubiomes.WIND_BURST()).put((Object)"mending", (Object)Cubiomes.MENDING()).put((Object)"unbreaking", (Object)Cubiomes.UNBREAKING()).put((Object)"curse_of_vanishing", (Object)Cubiomes.CURSE_OF_VANISHING()).put((Object)"curse_of_binding", (Object)Cubiomes.CURSE_OF_BINDING()).build();
    public static final Map<Integer, class_5321<class_1887>> ENCHANTMENT_ID_TO_MC = ImmutableMap.builder().put((Object)Cubiomes.PROTECTION(), (Object)class_1893.field_9111).put((Object)Cubiomes.FIRE_PROTECTION(), (Object)class_1893.field_9095).put((Object)Cubiomes.BLAST_PROTECTION(), (Object)class_1893.field_9107).put((Object)Cubiomes.PROJECTILE_PROTECTION(), (Object)class_1893.field_9096).put((Object)Cubiomes.RESPIRATION(), (Object)class_1893.field_9127).put((Object)Cubiomes.AQUA_AFFINITY(), (Object)class_1893.field_9105).put((Object)Cubiomes.THORNS(), (Object)class_1893.field_9097).put((Object)Cubiomes.SWIFT_SNEAK(), (Object)class_1893.field_38223).put((Object)Cubiomes.FEATHER_FALLING(), (Object)class_1893.field_9129).put((Object)Cubiomes.DEPTH_STRIDER(), (Object)class_1893.field_9128).put((Object)Cubiomes.FROST_WALKER(), (Object)class_1893.field_9122).put((Object)Cubiomes.SOUL_SPEED(), (Object)class_1893.field_23071).put((Object)Cubiomes.SHARPNESS(), (Object)class_1893.field_9118).put((Object)Cubiomes.SMITE(), (Object)class_1893.field_9123).put((Object)Cubiomes.BANE_OF_ARTHROPODS(), (Object)class_1893.field_9112).put((Object)Cubiomes.KNOCKBACK(), (Object)class_1893.field_9121).put((Object)Cubiomes.FIRE_ASPECT(), (Object)class_1893.field_9124).put((Object)Cubiomes.LOOTING(), (Object)class_1893.field_9110).put((Object)Cubiomes.SWEEPING_EDGE(), (Object)class_1893.field_9115).put((Object)Cubiomes.EFFICIENCY(), (Object)class_1893.field_9131).put((Object)Cubiomes.SILK_TOUCH(), (Object)class_1893.field_9099).put((Object)Cubiomes.FORTUNE(), (Object)class_1893.field_9130).put((Object)Cubiomes.LUCK_OF_THE_SEA(), (Object)class_1893.field_9114).put((Object)Cubiomes.LURE(), (Object)class_1893.field_9100).put((Object)Cubiomes.POWER(), (Object)class_1893.field_9103).put((Object)Cubiomes.PUNCH(), (Object)class_1893.field_9116).put((Object)Cubiomes.FLAME(), (Object)class_1893.field_9126).put((Object)Cubiomes.INFINITY_ENCHANTMENT(), (Object)class_1893.field_9125).put((Object)Cubiomes.QUICK_CHARGE(), (Object)class_1893.field_9098).put((Object)Cubiomes.MULTISHOT(), (Object)class_1893.field_9108).put((Object)Cubiomes.PIERCING(), (Object)class_1893.field_9132).put((Object)Cubiomes.IMPALING(), (Object)class_1893.field_9106).put((Object)Cubiomes.RIPTIDE(), (Object)class_1893.field_9104).put((Object)Cubiomes.LOYALTY(), (Object)class_1893.field_9120).put((Object)Cubiomes.CHANNELING(), (Object)class_1893.field_9117).put((Object)Cubiomes.DENSITY(), (Object)class_1893.field_50157).put((Object)Cubiomes.BREACH(), (Object)class_1893.field_50158).put((Object)Cubiomes.WIND_BURST(), (Object)class_1893.field_50159).put((Object)Cubiomes.MENDING(), (Object)class_1893.field_9101).put((Object)Cubiomes.UNBREAKING(), (Object)class_1893.field_9119).put((Object)Cubiomes.CURSE_OF_VANISHING(), (Object)class_1893.field_9109).put((Object)Cubiomes.CURSE_OF_BINDING(), (Object)class_1893.field_9113).build();

    public static ItemAndEnchantmentsPredicateArgument itemAndEnchantments() {
        return new ItemAndEnchantmentsPredicateArgument();
    }

    public static EnchantedItem getItemAndEnchantments(CommandContext<FabricClientCommandSource> context, String name) {
        return (EnchantedItem)context.getArgument(name, EnchantedItem.class);
    }

    public EnchantedItem parse(StringReader reader) throws CommandSyntaxException {
        return new Parser(reader).parse();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        Parser parser = new Parser(reader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (parser.suggestor != null) {
            parser.suggestor.accept(builder);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public record EnchantedItem(int item, Predicate<MemorySegment> enchantmensPredicate) {
    }

    private static class Parser {
        private final StringReader reader;
        private Consumer<SuggestionsBuilder> suggestor;

        private Parser(StringReader reader) {
            this.reader = reader;
        }

        private EnchantedItem parse() throws CommandSyntaxException {
            int item = this.parseItem();
            Predicate<MemorySegment> predicate = memorySegment -> true;
            if (!this.reader.canRead()) {
                return new EnchantedItem(item, predicate);
            }
            do {
                this.readWhitespace();
                int cursor = this.reader.getCursor();
                this.suggestor = suggestions -> {
                    SuggestionsBuilder builder = suggestions.createOffset(cursor);
                    class_2172.method_9253((String[])new String[]{"with", "without"}, (SuggestionsBuilder)builder);
                    suggestions.add(builder);
                };
                if (!this.reader.canRead()) break;
                boolean with = this.parseWithWithout();
                this.readWhitespace();
                int enchantment = this.parseEnchantment();
                this.readWhitespace();
                int enchantmentLevel = this.parseLevel();
                predicate = predicate.and(itemStack -> {
                    MemorySegment enchantments = ItemStack.enchantments(itemStack);
                    int enchantmentCount = ItemStack.enchantment_count(itemStack);
                    for (int i = 0; i < enchantmentCount; ++i) {
                        MemorySegment enchantInstance = EnchantInstance.asSlice(enchantments, i);
                        int itemEnchantment = EnchantInstance.enchantment(enchantInstance);
                        if (itemEnchantment != enchantment) continue;
                        if (enchantmentLevel == -1) {
                            return with;
                        }
                        int itemEnchantmentLevel = EnchantInstance.level(enchantInstance);
                        return with == itemEnchantmentLevel >= enchantmentLevel;
                    }
                    return !with;
                });
            } while (this.reader.canRead());
            return new EnchantedItem(item, predicate);
        }

        private int parseItem() throws CommandSyntaxException {
            int cursor = this.reader.getCursor();
            this.suggestor = suggestions -> {
                SuggestionsBuilder builder = suggestions.createOffset(cursor);
                class_2172.method_9265(ITEMS.keySet(), (SuggestionsBuilder)builder);
                suggestions.add(builder);
            };
            String itemString = this.reader.readUnquotedString();
            Integer item = ITEMS.get(itemString);
            if (item == null) {
                this.reader.setCursor(cursor);
                throw CommandExceptions.UNKNOWN_ITEM_EXCEPTION.create((Object)itemString);
            }
            return item;
        }

        private boolean parseWithWithout() throws CommandSyntaxException {
            String string;
            return switch (string = this.reader.readUnquotedString()) {
                case "with" -> true;
                case "without" -> false;
                default -> throw EXPECTED_WITH_WITHOUT_EXCEPTION.create();
            };
        }

        private int parseEnchantment() throws CommandSyntaxException {
            int cursor = this.reader.getCursor();
            this.suggestor = suggestions -> {
                SuggestionsBuilder builder = suggestions.createOffset(cursor);
                class_2172.method_9265(ENCHANTMENTS.keySet(), (SuggestionsBuilder)builder);
                suggestions.add(builder);
            };
            String enchantmentString = this.reader.readUnquotedString();
            Integer enchantment = ENCHANTMENTS.get(enchantmentString);
            if (enchantment == null) {
                this.reader.setCursor(cursor);
                throw CommandExceptions.UNKNOWN_ENCHANTMENT_EXCEPTION.create((Object)enchantmentString);
            }
            return enchantment;
        }

        private int parseLevel() throws CommandSyntaxException {
            int cursor = this.reader.getCursor();
            this.suggestor = suggestions -> {
                SuggestionsBuilder builder = suggestions.createOffset(cursor);
                builder.suggest("*");
                suggestions.add(builder);
            };
            if (this.reader.canRead() && this.reader.peek() == '*') {
                this.reader.skip();
                return -1;
            }
            return this.reader.readInt();
        }

        private void readWhitespace() throws CommandSyntaxException {
            if (!this.reader.canRead() || this.reader.peek() != ' ') {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherExpectedArgumentSeparator().createWithContext((ImmutableStringReader)this.reader);
            }
            this.reader.skipWhitespace();
        }
    }
}

