/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.command.arguments;

import com.google.common.base.Joiner;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;

public class SeedResolutionArgument
implements ArgumentType<SeedResolution> {
    private static final Collection<String> EXAMPLES = Arrays.asList("CommandSource SavedSeedsConfig OnlineDatabase SeedConfig", "CommandSource SeedConfig");
    private static final DynamicCommandExceptionType UNKNOWN_RESOLUTION_METHOD_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.exceptions.unknownResolutionMethod", (Object[])new Object[]{arg}));

    public static SeedResolutionArgument seedResolution() {
        return new SeedResolutionArgument();
    }

    public static SeedResolution getSeedResolution(CommandContext<FabricClientCommandSource> context, String name) {
        return (SeedResolution)context.getArgument(name, SeedResolution.class);
    }

    public SeedResolution parse(StringReader reader) throws CommandSyntaxException {
        return new Parser(reader).parse();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        Parser parser = new Parser(reader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (parser.suggestor != null) {
            parser.suggestor.accept(builder);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class SeedResolution
    implements Iterable<Method> {
        private final List<Method> methods;

        public SeedResolution() {
            this.methods = List.of(Method.values());
        }

        public SeedResolution(List<Method> methods) {
            this.methods = methods;
        }

        @Override
        @NotNull
        public Iterator<Method> iterator() {
            return this.methods.iterator();
        }

        public String toString() {
            return Joiner.on((String)" -> ").join(this.methods);
        }

        public static enum Method implements class_3542
        {
            COMMAND_SOURCE("CommandSource"),
            SEED_CONFIG("SeedConfig"),
            SAVED_SEEDS_CONFIG("SavedSeedsConfig"),
            ONLINE_DATABASE("OnlineDatabase");

            public static final class_3542.class_7292<Method> CODEC;
            private final String name;

            private Method(String name) {
                this.name = name;
            }

            @NotNull
            public String method_15434() {
                return this.name;
            }

            public String toString() {
                return this.method_15434();
            }

            static {
                CODEC = class_3542.method_28140(Method::values);
            }
        }
    }

    private static class Parser {
        private final StringReader reader;
        private Consumer<SuggestionsBuilder> suggestor;
        private final List<SeedResolution.Method> methods = new ArrayList<SeedResolution.Method>(Arrays.asList(SeedResolution.Method.values()));
        private final List<SeedResolution.Method> order = new ArrayList<SeedResolution.Method>();

        private Parser(StringReader reader) {
            this.reader = reader;
        }

        private SeedResolution parse() throws CommandSyntaxException {
            while (!this.methods.isEmpty()) {
                int cursor = this.reader.getCursor();
                this.suggestor = builder -> {
                    SuggestionsBuilder newBuilder = builder.createOffset(cursor);
                    class_2172.method_9264(this.methods.stream().map(SeedResolution.Method::method_15434), (SuggestionsBuilder)newBuilder);
                    builder.add(newBuilder);
                };
                if (!this.reader.canRead()) break;
                String methodString = this.reader.readUnquotedString();
                SeedResolution.Method method = (SeedResolution.Method)SeedResolution.Method.CODEC.method_42633(methodString);
                if (method == null) {
                    throw UNKNOWN_RESOLUTION_METHOD_EXCEPTION.create((Object)methodString);
                }
                if (this.order.contains((Object)method)) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
                }
                this.order.add(method);
                this.methods.remove((Object)method);
                if (!this.reader.canRead()) break;
                this.reader.expect(' ');
            }
            this.order.addAll(this.methods);
            return new SeedResolution(this.order);
        }
    }
}

